# Generated by https://quicktype.io

from enum import Enum
from typing import Optional, List, Any


class TypeEnum(Enum):
    FINAL_SLIDE = "FinalSlide"
    FULL_SLIDE = "FullSlide"
    TITLE_SLIDE = "TitleSlide"


class Structure:
    number: int
    type: TypeEnum
    key: str
    script: str
    title: str
    instructor_name: Optional[str]
    instructor_title: Optional[str]
    technology: Optional[str]
    citations: List[Any]
    code_zoom: int
    disable_transition: bool
    hide_slide_in_video: bool
    hide_title: bool
    use_full_width: bool
    part1: Optional[str]

    def __init__(
        self,
        number: int,
        type: TypeEnum,
        key: str,
        script: str,
        title: str,
        instructor_name: Optional[str],
        instructor_title: Optional[str],
        technology: Optional[str],
        citations: List[Any],
        code_zoom: int,
        disable_transition: bool,
        hide_slide_in_video: bool,
        hide_title: bool,
        use_full_width: bool,
        part1: Optional[str],
        **kwargs
    ) -> None:
        self.number = number
        self.type = type
        self.key = key
        self.script = script
        self.title = title
        self.instructor_name = instructor_name
        self.instructor_title = instructor_title
        self.technology = technology
        self.citations = citations
        self.code_zoom = code_zoom
        self.disable_transition = disable_transition
        self.hide_slide_in_video = hide_slide_in_video
        self.hide_title = hide_title
        self.use_full_width = use_full_width
        self.part1 = part1


class SlideDeck:
    key: str
    plain_video_hls_link: str
    plain_video_mp4_link: str
    plain_video_raw_link: None
    structure: List[Structure]
    timings: str
    title: str
    transformations: str

    def __init__(
        self,
        key: str,
        plain_video_hls_link: str,
        plain_video_mp4_link: str,
        plain_video_raw_link: None,
        structure: List[Structure],
        timings: str,
        title: str,
        transformations: str,
    ) -> None:
        self.key = key
        self.plain_video_hls_link = plain_video_hls_link
        self.plain_video_mp4_link = plain_video_mp4_link
        self.plain_video_raw_link = plain_video_raw_link
        self.structure = [Structure(**s) for s in structure]
        self.timings = timings
        self.title = title
        self.transformations = transformations


class Subtitle:
    language: str
    link: str

    def __init__(self, language: str, link: str) -> None:
        self.language = language
        self.link = link


class Video:
    audio_link: str
    key: str
    render_dynamically: int
    script_link: str
    slide_deck: SlideDeck
    slides_link: str
    subtitle_vtt_link: str
    subtitles: List[Subtitle]
    thumbnail_link: None
    transcript_timings: None
    type: str
    video_hls_link: None
    video_mp4_link: str
    video_raw_link: None

    def __init__(
        self,
        audio_link: str,
        key: str,
        render_dynamically: int,
        script_link: str,
        slide_deck: SlideDeck,
        slides_link: str,
        subtitle_vtt_link: str,
        subtitles: List[Subtitle],
        thumbnail_link: None,
        transcript_timings: None,
        type: str,
        video_hls_link: None,
        video_mp4_link: str,
        video_raw_link: None,
    ) -> None:
        self.audio_link = audio_link
        self.key = key
        self.render_dynamically = render_dynamically
        self.script_link = script_link
        self.slide_deck = slide_deck
        self.slides_link = slides_link
        self.subtitle_vtt_link = subtitle_vtt_link
        self.subtitles = [Subtitle(**s) for s in subtitles]
        self.thumbnail_link = thumbnail_link
        self.transcript_timings = transcript_timings
        self.type = type
        self.video_hls_link = video_hls_link
        self.video_mp4_link = video_mp4_link
        self.video_raw_link = video_raw_link
