# Generated by https://quicktype.io

from enum import Enum
from typing import Optional, List, Any


class TypeEnum(Enum):
    MULTIPLE_CHOICE_EXERCISE = "MultipleChoiceExercise"
    NORMAL_EXERCISE = "NormalExercise"
    VIDEO_EXERCISE = "VideoExercise"


class Exercise:
    type: TypeEnum
    title: str
    aggregate_xp: int
    number: int
    url: str

    def __init__(
        self,
        type: TypeEnum,
        title: str,
        aggregate_xp: int,
        number: int,
        url: str,
        **kwargs
    ) -> None:
        self.type = type
        self.title = title
        self.aggregate_xp = aggregate_xp
        self.number = number
        self.url = url


class Chapter:
    id: int
    title_meta: str
    title: str
    description: str
    number: int
    slug: str
    nb_exercises: int
    badge_completed_url: str
    badge_uncompleted_url: str
    last_updated_on: str
    slides_link: str
    free_preview: Optional[bool]
    xp: int
    number_of_videos: int
    exercises: List[Exercise]

    def __init__(
        self,
        id: int,
        title_meta: str,
        title: str,
        description: str,
        number: int,
        slug: str,
        nb_exercises: int,
        badge_completed_url: str,
        badge_uncompleted_url: str,
        last_updated_on: str,
        slides_link: str,
        free_preview: Optional[bool],
        xp: int,
        number_of_videos: int,
        exercises: List[Exercise],
        **kwargs
    ) -> None:
        self.id = id
        self.title_meta = title_meta
        self.title = title
        self.description = description
        self.number = number
        self.slug = slug
        self.nb_exercises = nb_exercises
        self.badge_completed_url = badge_completed_url
        self.badge_uncompleted_url = badge_uncompleted_url
        self.last_updated_on = last_updated_on
        self.slides_link = slides_link
        self.free_preview = free_preview
        self.xp = xp
        self.number_of_videos = number_of_videos
        self.exercises = [Exercise(**c) for c in exercises]


class Collaborator:
    avatar_url: str
    full_name: str

    def __init__(self, avatar_url: str, full_name: str) -> None:
        self.avatar_url = avatar_url
        self.full_name = full_name


class Dataset:
    asset_url: str
    name: str

    def __init__(self, asset_url: str, name: str) -> None:
        self.asset_url = asset_url
        self.name = name


class Instructor:
    id: int
    marketing_biography: str
    biography: str
    avatar_url: str
    full_name: str
    instructor_path: str

    def __init__(
        self,
        id: int,
        marketing_biography: str,
        biography: str,
        avatar_url: str,
        full_name: str,
        instructor_path: str,
        **kwargs
    ) -> None:
        self.id = id
        self.marketing_biography = marketing_biography
        self.biography = biography
        self.avatar_url = avatar_url
        self.full_name = full_name
        self.instructor_path = instructor_path


class SharingLinks:
    twitter: str
    facebook: str

    def __init__(self, twitter: str, facebook: str) -> None:
        self.twitter = twitter
        self.facebook = facebook


class Track:
    path: str
    title_with_subtitle: str

    def __init__(self, path: str, title_with_subtitle: str) -> None:
        self.path = path
        self.title_with_subtitle = title_with_subtitle


class Course:
    id: int
    title: str
    description: str
    short_description: str
    author_field: None
    author_bio: None
    author_image: str
    nb_of_subscriptions: int
    slug: str
    image_url: str
    image_thumbnail_url: str
    last_updated_on: str
    link: str
    should_cache: bool
    type: str
    difficulty_level: int
    state: str
    university: None
    sharing_links: SharingLinks
    marketing_video: str
    programming_language: str
    paid: bool
    time_needed: None
    xp: int
    topic_id: int
    technology_id: int
    reduced_outline: None
    runtime_config: None
    lti_only: bool
    instructors: List[Instructor]
    collaborators: List[Collaborator]
    datasets: List[Dataset]
    tracks: List[Track]
    prerequisites: List[Any]
    time_needed_in_hours: int
    seo_title: str
    seo_description: str
    archived_at: None
    original_image_url: str
    external_slug: str
    chapters: List[Chapter]

    def __init__(
        self,
        id: int,
        title: str,
        description: str,
        short_description: str,
        author_field: None,
        author_bio: None,
        author_image: str,
        nb_of_subscriptions: int,
        slug: str,
        image_url: str,
        image_thumbnail_url: str,
        last_updated_on: str,
        link: str,
        should_cache: bool,
        type: str,
        difficulty_level: int,
        state: str,
        university: None,
        sharing_links: SharingLinks,
        marketing_video: str,
        programming_language: str,
        paid: bool,
        time_needed: None,
        xp: int,
        topic_id: int,
        technology_id: int,
        reduced_outline: None,
        runtime_config: None,
        lti_only: bool,
        instructors: List[Instructor],
        collaborators: List[Collaborator],
        datasets: List[Dataset],
        tracks: List[Track],
        prerequisites: List[Any],
        time_needed_in_hours: int,
        seo_title: str,
        seo_description: str,
        archived_at: None,
        original_image_url: str,
        external_slug: str,
        chapters: List[Chapter],
        **kwargs
    ) -> None:
        self.id = id
        self.title = title
        self.description = description
        self.short_description = short_description
        self.author_field = author_field
        self.author_bio = author_bio
        self.author_image = author_image
        self.nb_of_subscriptions = nb_of_subscriptions
        self.slug = slug
        self.image_url = image_url
        self.image_thumbnail_url = image_thumbnail_url
        self.last_updated_on = last_updated_on
        self.link = link
        self.should_cache = should_cache
        self.type = type
        self.difficulty_level = difficulty_level
        self.state = state
        self.university = university
        self.sharing_links = sharing_links
        self.marketing_video = marketing_video
        self.programming_language = programming_language
        self.paid = paid
        self.time_needed = time_needed
        self.xp = xp
        self.topic_id = topic_id
        self.technology_id = technology_id
        self.reduced_outline = reduced_outline
        self.runtime_config = runtime_config
        self.lti_only = lti_only
        self.instructors = [Instructor(**c) for c in instructors]
        self.collaborators = [Collaborator(**c) for c in collaborators]
        self.datasets = [Dataset(**c) for c in datasets]
        self.tracks = [Track(**c) for c in tracks]
        self.prerequisites = prerequisites
        self.time_needed_in_hours = time_needed_in_hours
        self.seo_title = seo_title
        self.seo_description = seo_description
        self.archived_at = archived_at
        self.original_image_url = original_image_url
        self.external_slug = external_slug
        self.chapters = [Chapter(**c) for c in chapters]
