<p align="center">
    <a href="https://django-salesman.readthedocs.org/">
        <img src="https://cdn.jsdelivr.net/gh/dinoperovic/django-salesman@master/docs/_static/logo.svg" width="250" alt="Salesman logo">
    </a>
</p>
<h3 align="center">Headless e-commerce framework for Django.</h3>
<p align="center">
    <a href="https://pypi.org/project/django-salesman/">
        <img alt="PyPI" src="https://img.shields.io/pypi/v/django-salesman">
    </a>
    <a href="https://github.com/dinoperovic/django-salesman/actions?query=workflow:Test">
        <img alt="GitHub Workflow Status (branch)" src="https://img.shields.io/github/workflow/status/dinoperovic/django-salesman/Test/master">
    </a>
    <a href="http://codecov.io/github/dinoperovic/django-salesman">
        <img alt="Codecov branch" src="https://img.shields.io/codecov/c/github/dinoperovic/django-salesman/master">
    </a>
    <a href="https://pypi.org/project/django-salesman/">
        <img alt="PyPI - Python Version" src="https://img.shields.io/pypi/pyversions/django-salesman">
    </a>
    <a href="https://pypi.org/project/django-salesman/">
        <img alt="PyPI - Django Version" src="https://img.shields.io/pypi/djversions/django-salesman">
    </a>
    <a href="https://github.com/psf/black">
        <img alt="Code style: black" src="https://img.shields.io/badge/code%20style-black-000000.svg">
    </a>
</p>

**Salesman** provides a configurable system for building an online store.
It includes a clean **REST** based API with endpoints for manipulating the basket,
processing the checkout and payment operations as well as managing customer orders.

## Features

- API endpoints for **Basket**, **Checkout** and **Order**
- Support for as many **Product** types needed using generic relations
- Pluggable **Modifier** system for basket processing
- **Payment** methods interface to support any gateway necessary
- Customizable **Order** model
- [Wagtail](https://wagtail.io/) and **Django** admin implementation

## Documentation

Documentation is available on [Read the Docs](https://django-salesman.readthedocs.org).

<p>
    <a href="https://www.buymeacoffee.com/dinoperovic">
        <img src="https://cdn.jsdelivr.net/gh/dinoperovic/django-salesman@master/docs/_static/buymeacoffee.svg" alt="Buy me a coffee">
    </a>
</p>
