"""Module with models for graph machine learning and visualization."""
from embiggen.visualizations import GraphVisualizer
from embiggen.utils import (
    EmbeddingResult,
    get_models_dataframe,
    get_available_models_for_node_label_prediction,
    get_available_models_for_edge_prediction,
    get_available_models_for_edge_embedding,
    get_available_models_for_edge_label_prediction,
    get_available_models_for_node_embedding,
)

__all__ = [
    "GraphVisualizer",
    "EmbeddingResult",
    "get_models_dataframe",
    "get_available_models_for_node_label_prediction",
    "get_available_models_for_edge_embedding",
    "get_available_models_for_edge_prediction",
    "get_available_models_for_edge_label_prediction",
    "get_available_models_for_node_embedding",
]
