## chariot-sdk

---

### 简介
千乘插件生成器

### 环境要求
- python 3.8+

### 安装
> pip install chariot-sdk

### 更新日志

> 1.2.10 -> 1.3.0

- 修复了非Debug模式下，debug等级的日志仍然会在某种条件下输出的bug
- 修复了Debug模式切换后无法切换回去的bug
- 调整了重载配置行为的位置，修复了原来在完成连接器的运行后才加载配置的bug
- 新增资产接收器模块，此模块专门用于转发资产相关的信息
- 新增查询插件使用SDK版本信息接口
- 新增查询插件定义文件接口
- 新增api服务的多进程支持，现在可以在使用http命令时后面跟随一个数字从而决定一次启用的API进程数量，缺省为4个进程，此功能适用于需要长时间等待的业务
- yaml模板文件添加multi_workers参数，以告诉千乘系统此插件是否支持多进程
- 优化了热更新时的版本比对条件，现在SDK会拒绝大版本的热更新，只允许小版本更新，大版本更新应该重新安装插件
- 重构了热更新功能，现在SDK可以对业务代码的变动进行实时重载，不再需要重启api服务（你甚至可以一边开着API服务一边编写插件），这将极大降低插件测试难度
- 重构了插件打包功能，现在windows和linux两种环境下都可以打包在线包和离线包了（前提是有docker环境）
- 重构了日志记录功能
- 重构了触发器、告警接收器、情报接收器的运行接口
- 重构了所有功能的连接器测试接口
- 优化了生成tests目录下测试文件的功能，现在在插件定义文件中定义的参数会在生成json测试文件时自动占位
- config.ini文件新增ignore参数，可以通过填写此参数来添加打包插件时需要忽略的文件，在使用此版本SDK生成插件时，SDK会尝试自动添加上去，并会添加一些常见的需要忽略的文件，目前只支持忽略根目录下第一层级的文件和文件夹
- 重新编排了chariot-plugin -h中的帮助内容

> 1.2.8 -> 1.2.10 （在1.3.0版本前将全是健康性更新，不会增加新的功能）

- 修复了一些参数的缺少问题
- 优化了库的引用
- 优化了一些参数的命名

> 1.2.7 -> 1.2.8

- 新增了本地缓存和在线缓存功能
- 新增了自动生成插件功能，目前仅支持简单的Request行为
- 新增了容器内插件热更新功能，向提供的API接口上传新的插件包代码包即可
- 新增了创建触发器、告警接收器和情报接收器的API接口，现在可以直接通过请求同时创建多个进程
- 新增了转发数据测试接口
- 新增了对JSON格式的插件定义文件支持
- 新增了重启插件功能
- 新增了关闭插件API服务的接口
- 新增了对插件运行的配置文件config.ini，它会在生成插件时自动生成在插件根目录下，这里可以配置SDK的日志记录及一些其他性能上参数
- 优化了SDK的日志记录，现在插件不会再因为日志过多而运行缓慢了，日志记录配置可以在config.ini中修改，也可通过API接口传入数据修改
- 优化了SDK转发大量数据时过慢的问题，现在会采用多线程的方式转发数据，线程数量可在config.ini中调整
- 优化了数据验证，现在数据验证失败时会在返回的错误信息中提示
- 优化了剔除载荷中空参数的方法，现在该方法由self._popEmpty()改为popEmpty()，在向旧版本插件进行生成操作时，SDK会尝试自动修正该引用
- SDK运行的需求库新增python-multipart，在向旧版本插件进行生成操作时，会尝试自动添加在requirement.txt中

> 1.2.6 -> 1.2.7

- 全新的日志记录系统，所有开发和运行时的警告、错误以及值得注意的信息都将以不同的颜色进行高亮显示，并且日志记录方法调用更加方便
- 重构了SDK大部分功能的实现，极大地提高了可维护性和扩展性，大量重复的功能已重构为使用统一的函数处理
- 优化SDK运行逻辑，业务错误将不再影响SDK的运行，但是会触发SDK的错误信息收集机制
- 优化生成插件文件时的逻辑，一些文件在重写生成插件时不再会被覆盖
- 优化了SDK对yaml文件的读取，SDK会对一些必要的数据进行审查，以减少开发阶段出现的bug
- 可以通过命令自动生成一个yaml模板文件