"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const tasks = require("../lib");
let stack;
beforeEach(() => {
    stack = new core_1.Stack();
});
test('Eval with Node.js', () => {
    // WHEN
    const task = new sfn.Task(stack, 'Task', {
        task: new tasks.EvaluateExpression({
            expression: '$.a + $.b',
        }),
    });
    new sfn.StateMachine(stack, 'SM', {
        definition: task,
    });
    // THEN
    expect(stack).toHaveResource('AWS::StepFunctions::StateMachine', {
        DefinitionString: {
            'Fn::Join': [
                '',
                [
                    '{"StartAt":"Task","States":{"Task":{"End":true,"Parameters":{"expression":"$.a + $.b","expressionAttributeValues":{"$.a.$":"$.a","$.b.$":"$.b"}},"Type":"Task","Resource":"',
                    {
                        'Fn::GetAtt': [
                            'Evala0d2ce44871b4e7487a1f5e63d7c3bdc4DAC06E1',
                            'Arn',
                        ],
                    },
                    '"}}}',
                ],
            ],
        },
    });
    expect(stack).toHaveResource('AWS::Lambda::Function', {
        Runtime: 'nodejs10.x',
    });
});
test('Throws when expression does not contain paths', () => {
    // WHEN
    expect(() => new sfn.Task(stack, 'Task', {
        task: new tasks.EvaluateExpression({
            expression: '2 + 2',
        }),
    })).toThrow(/No paths found in expression/);
});
//# sourceMappingURL=data:application/json;base64,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