# Docker nodes

Nodes in Docker swarm

Don't use the constructor directly. Instead use 
```python
from dockertown import docker

my_docker_image = docker.node.inspect("my-node-name")

list_of_nodes = docker.node.list()
```
For type hints, use this

```python
from dockertown import Node

def print_state(node: Node):
    print(node.status.state)
```


## Attributes

It attributes are the same that you get with the command line:
`docker node inspect ...`

To get a complete description of those attributes, you 
can take a look at the [daemon api reference page](https://docs.docker.com/engine/api/v1.40/#operation/NodeInspect) 
and click on "200 No error".

An example is worth many lines of descriptions.

```
In [1]: from dockertown import docker

In [2]: docker.swarm.init()

In [3]: docker.node.list()[0]

In [4]: def super_print(obj):
   ...:     print(f"type = {type(obj)}, value = {obj}")
   ...:

@INSERT_GENERATED_CODE@
```

## Methods

{{autogenerated}}
