# -*- coding:utf-8 -*-
from pathlib import Path
from typing import Union, Any, Optional

from .base import OriginalRecorder, BaseRecorder
from .style import CellStyle
from .db_recorder import DBRecorder
from .filler import Filler
from .recorder import Recorder


class OriginalSetter(object):
    _recorder: OriginalRecorder = ...

    def __init__(self, recorder: OriginalRecorder): ...

    def cache_size(self, size: int) -> None: ...

    def path(self, path: Union[str, Path]) -> None: ...

    def show_msg(self, on_off: bool) -> None: ...


class BaseSetter(OriginalSetter):
    _recorder: BaseRecorder = ...

    def table(self, name: Union[str, bool]) -> None: ...

    def before(self, before: Any) -> None: ...

    def after(self, after: Any) -> None: ...

    def encoding(self, encoding: str) -> None: ...


class SheetLikeSetter(BaseSetter):
    _recorder: Union[Filler, Recorder] = ...

    def head(self, head: Union[list, tuple], table: str = None) -> None: ...

    def delimiter(self, delimiter: str) -> None: ...

    def quote_char(self, quote_char: str) -> None: ...

    def path(self, path: Union[str, Path], file_type: str = None) -> None: ...

    def file_type(self, file_type: str) -> None: ...

    def table(self, name: Union[str, bool]) -> None: ...


class FillerSetter(SheetLikeSetter):
    _recorder: Filler = ...

    def __init__(self, recorder: Filler): ...

    def sign(self, value: Any) -> None: ...

    def deny_sign(self, on_off: bool = True) -> None: ...

    def key_cols(self, cols: Union[str, int, list, tuple, bool]) -> None: ...

    def sign_col(self, col: Union[str, int, bool]) -> None: ...

    def data_col(self, col: Union[str, int]) -> None: ...

    def begin_row(self, row: int) -> None: ...

    def path(self, path: Union[str, Path] = None, key_cols: Union[str, int, list, tuple, bool] = None,
             begin_row: int = None, sign_col: Union[str, int, bool] = None,
             data_col: Union[str, int] = None, sign: Any = None, deny_sign: bool = None) -> None: ...

    def link_style(self, style: CellStyle) -> None: ...

    def row_num_title(self, title: str) -> None: ...


class RecorderSetter(SheetLikeSetter):
    _recorder: Recorder = ...

    def __init__(self, recorder: Recorder): ...

    def follow_styles(self, on_off: bool = True) -> None: ...

    def col_height(self, height: float) -> None: ...

    def style(self, style: CellStyle) -> None: ...

    def path(self, path: Union[str, Path], file_type: str = None) -> None: ...

    def head(self, head: Union[list, tuple], table: str = None) -> None: ...

    def fit_head(self, on_off: bool = True) -> None: ...


class DBSetter(BaseSetter):
    _recorder: DBRecorder = ...

    def __init__(self, recorder: DBRecorder): ...

    def path(self, path: Union[str, Path], table: Optional[str] = None) -> None: ...


def set_csv_head(file_path: str, head: Union[list, tuple], encoding: str = 'utf-8', delimiter: str = ',',
                 quote_char: str = '"'): ...


def set_xlsx_head(file_path: str, head: Union[list, tuple], table: str) -> None: ...
