# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['mnemocards', 'mnemocards.builders']

package_data = \
{'': ['*'],
 'mnemocards': ['assets/css/*',
                'assets/css/highlight/.gitignore',
                'assets/css/highlight/.gitignore',
                'assets/css/highlight/.gitignore',
                'assets/css/highlight/github.css',
                'assets/css/highlight/github.css',
                'assets/css/highlight/github.css',
                'assets/css/highlight/makefile',
                'assets/css/highlight/makefile',
                'assets/css/highlight/makefile']}

install_requires = \
['Pygments>=2.5.2,<3.0.0',
 'anki>=2.1.33,<3.0.0',
 'chardet==3.0.4',
 'genanki-mnemocards>=0.11.0,<0.12.0',
 'googletrans==3.1.0a0',
 'gtts>=2.2.2,<3.0.0',
 'iso-639>=0.4.5,<0.5.0',
 'markdown2>=2.3.8,<3.0.0',
 'protobuf>=3.13.0',
 'pygithub>=1.45,<2.0',
 'pykakasi>=2.0.4,<3.0.0']

entry_points = \
{'console_scripts': ['mnemocards = mnemocards.__main__:main']}

setup_kwargs = {
    'name': 'mnemocards',
    'version': '0.1.4',
    'description': "Flashcards generator. You won't forget anything...",
    'long_description': '\n<img src="doc/_static/images/logo.png" width="200">\n<br />\n<a href="https://mnemocards.readthedocs.io/en/latest/">\n    <img src="https://readthedocs.org/projects/mnemocards/badge"\n         alt="Read The Docs documentation">\n</a>\n\nGenerate Anki cards from text files (TSV and Markdown).\nAutomatically create cards from list of words with Google Translate.\n\n<center>\n<img src="doc/_static/images/all_cards.png">\n</center>\n\nText files are easily maintainable, `apkg` files are not.\nYou can easily store text files in a version control system like *git*, so you\ncan easily keep track of changes and collaborate with others.\n\nMnemocards comes with some pre-design formats:\n\n * **Language cards** (first row of the last picture):\n Specially designed for learning a language.\n There are two types of language cards:\n   * **Vocabulary cards** (right):\n   Cards displayed in 2 languages, your native language and the language you\n   are learning.\n   This type of card gives you the possibility to auto-generate pronunciation\n   audios directly from Google Translator.\n   Also, if you are learning Japanese you can use ふりがな (furigana, the\n   small hiragana characters on top of the Kanji)!\n   * **Expression cards** (left):\n   When you already know a language and want to master it, sometimes it is no\n   longer enough to translate into your language, but you want to write\n   sentences in the language you are learning with their respective explanation\n   also in the language you are learning.\n * **Markdown cards** (second row):\n Cards generated from `*.cards` files.\n This file format has been created specifically for the creation of cards with\n Mnemocards.\n Apart from a pair of start and end of card markers, the syntax of these files\n is pure Markdown.\n You can use images, Latex and math in this kind of cards.\n* **Autogenerated cards**(picture below):\n These cards are generated fully-automatically from a simple `*.txt` file with\n a list of words (or phrases) in a language you learn. Each word is translated\n to your own language using Google Translate and then formatted using\n **Vocabulary cards** template.\n Each card will have everything you\'ll see on the Google Translate page - the\n word itself, main translation, additional synonym translations, pronunciation,\n definitions (in a language of original word, with example sentences). \n For some words (and most phrases) Google Translate will lack some items, but\n will have only one main translation.\n Additionally you can generate pronunciation audios - it will work regardless\n of the word having a text pronounciation on Google Translate page, and can be\n generated for phrases too. \n And if you create autogenerated cards from japanese words and phrases - you\n can auto-generate furigana too! \n\n<center>\n<img src="doc/_static/images/autogenerated_cards.png"  width="70%">\n</center>\n\n# Requirements\n\n * PyAudio, one of the Python dependencies requires the installation of\n **PortAudio-dev**.\n Install the package in Ubuntu-like systems (bionic) with\n `apt install portaudio19-dev=19.6.0-1build1`.\n Maybe any other version of the package is working but that one is the one\n I\'m using without problems.\n Remove the version if you have any problem and try with the last one.\n * **Python 3** and all the libraries listed in `requirements.txt`.\n All these requirements are automatically installed when you install the\n package with `pip install .`.\n If you want to install the requirements manually just use:\n `pip install -r requirements.txt`.\n You need at least `pip>=10`.\n * If you want to **import automatically the generated apkgs**, you should\n have **Anki** installed.\n * If you want to **generate cards from your repositories or gists** you should\n have **Git** installed.\n Install it in Ubuntu-like systems with `apt install git`.\n Also, in order to use the GitHub API you should have a file with and API key\n with gists/repository permissions.\n The repository permission is only needed for private repositories.\n\n\n# Installation\n\nUsing PyPi package with `pip`:\n```bash\npip install --no-deps mnemocards\npip install mnemocards\n```\nThis fancy way of installing the package is because PyPi does not allow the\ninstallation of packages that have dependencies hosted outside PyPi.\nMnemocards has one dependency that should be cloned from GitHub, my own\nfork from the [Genanki Python library][genanki].\nInstalling the package first and the dependencies later seems to be a good\nworkaround.\n\nInstalling from source code is even simpler.\nClone this repository, move to the root of the project and run:\n```bash\npip install .\n```\n\nIf you want to contribute or develop use:\n```bash\npip install -e .\n```\n\nRemember to have at least the version 10 of `pip`.\n\n:warning: Avoid using `python setup.py install` or `python setup.py develop` because it\ndoes not understand direct references in the requirements and installs a\ndifferent version of Genanki (installs the PyPi package instead of my GitHub\nfork).\n\nConsider the option of using Docker if you do not want to install\nthe package and to set up all the needed environment.\nRead the [Docker section](#docker) of this README to learn more about it.\n\n\n# Generate cards\n\nMove into the `examples/` directory and execute the next line to generate\nall the `*.apkg` files in this directory and all the subdirectories.\n```\n$ mnemocards generate -r .\nBuilding ./computer_science/cards_config.json\n        Building deck:  Computer Science  ID: 3778079933\nBuilding ./japanese/cards_config.json\nCreating audio file ./japanese/media/hiragana/10091493812914340822.mp3\nCreating audio file ./japanese/media/hiragana/7304217433350980427.mp3\nCreating audio file ./japanese/media/hiragana/3595385396154511079.mp3\nCreating audio file ./japanese/media/hiragana/5000408949304965326.mp3\nCreating audio file ./japanese/media/hiragana/2088116759824648408.mp3\nCreating audio file ./japanese/media/katakana/13050069045466478331.mp3\nCreating audio file ./japanese/media/katakana/4834734646036555229.mp3\nCreating audio file ./japanese/media/katakana/4275246117432970461.mp3\nCreating audio file ./japanese/media/katakana/8563378359496393897.mp3\nCreating audio file ./japanese/media/katakana/10683512746176998599.mp3\n        Building deck:  Japanese Scripts  ID: 46741143\nBuilding ./english/cards_config.json\n        Building deck:  English  ID: 376026414\nBuilding ./gtrans_generated/from_words/cards_config.json\nCreating audio file ./gtrans_generated/from_words/.media/16602724546385148562.mp3\nCreating audio file ./gtrans_generated/from_words/.media/5309234024643684554.mp3\nCreating audio file ./gtrans_generated/from_words/.media/16025915470194576015.mp3\nCreating audio file ./gtrans_generated/from_words/.media/3362678031558458662.mp3\n        Building deck:  English-Spanish googletranslated  ID: 2639255077\nBuilding ./gtrans_generated/from_tsv/cards_config.json\nCreating audio file ./gtrans_generated/from_tsv/.media/9906647659348914100.mp3\nCreating audio file ./gtrans_generated/from_tsv/.media/93519578040143984.mp3\nCreating audio file ./gtrans_generated/from_tsv/.media/17049437411425550802.mp3\nCreating audio file ./gtrans_generated/from_tsv/.media/8896291257694557922.mp3\nCreating audio file ./gtrans_generated/from_tsv/.media/933277714999002525.mp3\n        Building deck:  Japanese-English googletranslated  ID: 2732900318\nWriting packages to a file...\n$ ls\ncomputer_science  cs.apkg  english  english.apkg  gtrans_generated  gtrans_generated_from_tsv.apkg  gtrans_generated_from_words.apkg  japanese  japanese.apkg\n```\n\nNow you have 5 `*.apkg` files in this directory that you can import to Anki\nmanually or using Mnemocards (see the [import section](#import-cards-to-anki)).\nDuring the generation process 10 audio files has been created for the Japanese\ndecks, 4 for english-spanish deck generated from word file and another\n5 audio files for japanese-english deck generated from tsv file.\nThese audio files come from Google Translator.\nIf you repeat the command again, no audio is downloaded again, so the process\nof adding new words to a vocabulary is going to be faster.\n\nMnemocards commands come with documentation that you can read adding `--help`\nto any command.\nFor example, if you want to see all the options you can use with the `generate`\ncommand just execute:\n```\n$ mnemocards generate --help\nusage: mnemocards generate [-h] [--config-file CONFIG_FILE] [--recursive]\n                           [--output-dir OUTPUT_DIR]\n                           DATA_DIR\n\npositional arguments:\n  DATA_DIR              Directory with the configuration and text data to use\n                        for generating the Anki cards.\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --config-file CONFIG_FILE, -f CONFIG_FILE\n                        Configuration file to search in the DATA_DIR.\n  --recursive, -r       Search recursively for configuration files in the\n                        given DATA_DIR.\n  --output-dir OUTPUT_DIR, -o OUTPUT_DIR\n                        Output directory where the packages are going to be\n                        saved. Current directory by default.\n```\n\nThe process of generating Anki `*.apkg` files is based on the use of\nconfiguration files.\nBy default, the configuration file is called `cards_config.json`.\nThere are five different `cards_config.json` in the examples, one in each\ndirectory (`computer_science/cards_config.json`, `english/cards_config.json`,\n`japanese/cards_config.json`,`gtrans_generated/from_tsv/cards_config.json` and\n`gtrans_generated/from_words/cards_config.json`)\n\nThe `-r` option used in the `generate` command indicates Mnemocards to search\nfor those configuration files recursively.\nIf you want to generate only the `japanese.apkg` use\n`mnemocards generage japanese` or move into `examples/japanese` and execute\nthere `mnemocards generate .`.\n\n\n## Configuration files `cards_config.json`\n\nConfiguration files contain how many packages to build, the number of decks,\ndeck configurations and the input source of the data (TSV files and Markdown\nfiles).\n\nThe most basic configuration file is:\n```json\n{\n    "packages": [\n        {\n            "name": "APKG_filename",\n            "decks": [\n                {\n                    "id": "ad054cdc-160b-4b77-a8a5-4da79fe5d8a5",\n                    "name": "Deck name",\n                    "src": [\n                        {\n                            "type": "markdown",\n                            "file": "my_file.cards",\n                        }\n                    ]\n                }\n            ]\n        }\n    ]\n}\n```\n\nEach configuration file can generate one or more `*.apkg` packages.\nEach package can contain one or more decks.\nEach deck can consist of one or more source text files.\n\nIt is recommended to specify a deck ID, otherwise a hash of the deck name will\nbe used, which implies that if the name is changed the deck will be considered\nas a new deck by Anki, loosing any learning progress.\n\nApart from the deck ID, name and source files, you can specify a deck config.\nLook to this example:\n```\n{\n    "id": "e9a0b7ba-641a-4af6-8631-be9854a4e9d8",\n    "name": "My deck name",\n    "config": {\n        "id": "65bcc65b-b4de-4ce4-b5c1-a73a2f64b82d",\n        "name": "My deck name (Configuration)",\n        "timer": 1,  # Active timer\n        "maxTaken": 30,  # Max seconds taken by the timer\n        "new": {\n            "bury": true,  # Bury related new cards\n            "initialFactor": 1500,  # Initial ease factor\n            "perDay": 5,  # Number of new cards per day\n            "delays": [1, 10, 1440, 4320, 10080],  # Learning steps in minutes\n        },\n        "lapse": {\n            "leechAction": 1  # Mark leech cards. Set to 0 to suspend.\n        }\n    }\n}\n```\n\nNote that the comments added to the right of some properties are not a valid\nJSON syntax, they are added here only for this tutorial.\nYou can read about [all the deck config options][ankidroidDeckConfig] you can\nuse in the Ankidroid documentation.\n\nThe `src` property should have at least one file in order to generate\nsome cards for that deck.\n`type` and `file` are the two required properties.\nDepend on the type you can add more properties.\n\n\n### `markdown` type\n\n```json\n{\n    "type": "markdown",\n    "file": "math.cards",\n    "card_properties": {\n        "tags": ["math"]\n    }\n}\n```\n\nApart from `type` and `file` you can add:\n* `card_properties`.\nProperties that are applied to all the cards in this file.\nFor exampe: using this property you avoid setting tags in all the cards inside\nof that file.\n    * `tags`. The tag property is the only one available at the moment.\n    It is an array of tags.\n    Even if you only what to specify one tag you should use an array with one\n    element.\n\n\n### `vocabulary` type\n\n```json\n{\n    "type": "vocabulary",\n    "file": "hiragana.tsv",\n    "header": true,\n    "pronunciation_in_reverse": false,\n    "card_color": "#33AA33",\n    "furigana": false,\n    "audio": {\n        "lang": "ja",\n        "media_dir": "media/hiragana"\n    },\n    "card_properties": {\n        "tags": ["japanese", "hiragana"]\n    }\n},\n```\n\n* `header`. The first line of the TSV file is a header line, so it will be\nskipped.\n* `pronunciation_in_reverse`.\nBy default, when the vocabulary card is shown in reverse the pronunciation\nis not showed.\nSet this option to true if you want want the pronunciation.\nIt will be shown once you press the *Show answer* button.\n* `card_color`.\nCard background color in hexadecimal.\n* `furigana`.\nIf you are learning Japanese, maybe you want to use furigana (small hiragana\ncharacters over Kanji) in your cards.\nSet this flag to true if you want to use them, by default false.\nIn your TSV files your furigana must be written between brackets and with a\nspace before the Kanji.\nFor example, `日[に] 本[ほん] 語[ご]`.\n* `audio`. If you want to generate and audio file of the language you are\nlearning, you should specify here the language.\n    * `lang`. The language used to generate those file using ISO 639-2.\n    You can find a [table with the ISO 639-2][wikipediaIso2] for all the\n    languages in Wikipedia.\n    If the pronunciation is not available in Google Translator this is not\n    going to work.\n    * `media_dir`. Directory where the audio files are stored.\n    After generating the package for the first time, this folder will be\n    created and filled with all the audio files.\n    If you don\'t delete this folder, the next time Mnemocards will be much\n    faster because it already has all the audio files generated.\n* `card_properties` has the same meaning as in Markdown cards.\n\n\n### `expression` type\n\n```json\n{\n    "type": "expression",\n    "file": "expressions.tsv",\n    "header": true,\n    "card_color": "#AA3333",\n    "card_properties": {\n        "tags": ["english", "expressions"]\n    }\n}\n```\n\n`header`, `card_color` and `card_properties` have the same meaning as in\nvocabulary cards.\n\n\n### `autogenerate` type\n\n```json\n{\n    "type": "autogenerate",\n    "file": "words.txt",\n    "pronunciation_in_reverse": true,\n    "card_color": "#f5f5f5",\n    "lang": {\n        "original": "en",\n        "translation": "es"\n    },\n    "audio": true,\n    "furigana": false,\n    "furigana_type": "hepburn",\n    "card_properties": {\n        "tags": ["english","spanish", "autogenerated" ]\n    }\n}\n```\n\n* `file`. \nThis type is for generating cards automatically from a list of words in a\n`*.txt` file. The file should contain one word or phrase per line without\nseparator such as `.` or `,` at the end of the line. \nThis type can also be used to generate card from automatically generated \n`*.tsv` files - for instructions on how to generate TSV-files read the section \n[`Autogenerate TSV files with maketsv command`](#autogenerate-tsv-files-with-maketsv-command)\n* `lang`.\nYou should specify here the languages for automatic translation.\nList of language codes is available [here](https://py-googletrans.readthedocs.io/en/latest/#googletrans-languages)\n    * `original`. Language code for language of words in the file.\n    * `translation`. Language code for your language.\n* `furigana`.\nThis flag works the same as in `vocabulary` type, but generates furigana \nautomatically.\nThis flag only works if the `lang:original` is set to japanese (`ja`). \nIf furigana is activated, pronunciation from Google Translate will be removed\nfrom the card.\nBy default false.\n* `furigana_type`.\nYou can choose what type of transliteration to use for furigana. Avaiable values\n`hira` for hiragana (this is set by default if you skip this flag), `kana` for\nkatakana and `hepburn` for romaji.\n* `audio`.\nThis flag works a little different then in `vocabulary` type and\nhas to be set true to work. By default false.\n* `pronunciation_in_reverse`, `card_color`, `card_properties` has the same \nmeaning as in vocabulary cards.\n\n:warning: Due to limitations of Google Translate API, the program can download\ntranslations only for 25 words per 3 minute. If you use `autogenerate` type on \nlist of more then 25 words, the program will make 3 minute delays for every 25 \nwords and generation can take a large amount of time dependent of total number \nof words.\n\n## `*.cards` file format\n\nA card has the following syntax:\n```card\n<<<\nheader\n===\ntitle\n---\nbody\n>>>\n```\n\nThe header section contains some metadata about the card (ID and tags), the\ntitle is the front part of the card and the body in the hidden part that is\nshown when you press the *Show Answer* button on Anki.\n\nThe header section has a *YAML* syntax and the title and body section use\nMarkdown syntax.\nNotice than the separators `===` and `---` are legal Markdown syntax for\ngenerating headers, so it\'s recommended to use `#` and `##` instead in your\ntitle and body.\n\nThe header and the body are not required, so the next example is also a card:\n```card\n<<<\ntitle\n>>>\n```\n\nHowever, it\'s highly recommended to give an ID to your cards.\nIf no ID is used, a hash of the title is going to be used as ID.\nThat means that the card ID will change if the title is changed (titles are\nprone to change because of typos or future improvements you want to make to\nyour cards).\nCards with different IDs are considered as different cards by Anki, so you\nwill have duplicates and the new card will loose any progress.\nUse IDs please.\nThe ID is given in the header and it\'s recommended to use a GUID:\n```card\n<<<\nid: 07924f36-ccfa-4b72-ac21-11f8b151d42f\n===\n# Title\n---\nBody\n>>>\n```\n\nAnother legal property that you can define in the header are tags.\nUse a comma separated list with the names of all the tags you want to assign\nto that card:\n```card\n<<<\nid: 07924f36-ccfa-4b72-ac21-11f8b151d42f\ntags: tag1,tag2,tag3\n===\n# Title\n>>>\n```\n\nUse inline math formulas using a dollar (ex: `$x^2$`) and a multi-line formula\nusing two dollars (ex: `$$\\sum_i x_i$$`) in any part of the title or body.\n\nYou can also add images to the cards using an `<img>` tag.\nAt the moment the Markdown syntax for images `![alt](url)` is not supported.\nNotice that the image names should be unique over all the images in your Anki\ndecks, so avoid names like `1.png` or `example.png`.\n\n\n## TSV Vocabulary files\n\nTSV vocabulary files should contain the next columns.\nAt the moment, the columns **should be in the given order**.\n\n* `ID`.\nCharacters that uniquely identify a note.\nThis number must be unique not only in the file but in the whole collection,\nthat is why we recommend using a UUID (a sequence of alphanumeric characters\nsuch as: 64012c71-9aea-4622-aac7-2595d6798737).\nHaving a UUID is necessary to be able to update the cards (make spelling\ncorrections or improve them with extra information) and not lose the progress.\nIf you need to generate UUID for your card when you first compose it, use \ncommand `mnemocards id`\n\n* `YourLanguageWord`.\nThe word you want to learn but in your mother tongue or in a known language.\n* `YourLanguageExplanation`.\nAny extra detail to help you get the word you\'re looking for.\nA clear example of use is when you have to explain a word that does not have a\ndirect translation in your language or when the translation in your language\nis a word that has more than one meaning.\nFor example: in Japanese flat and thin objects use different numbers, so the\ntranslation of 一枚 is obviously "one" but to make the reverse translation we\nneed a clarification like "one, when counting flat and thin objects".\n* `LanguageYouLearnWord`.\nThe word written in the language you are trying to learn.\n* `LanguageYouLearnPronunciation`.\nWrite here how you can pronounce the word of the language you are learning.\nIf you choose to generate an audio with the pronunciation, the audio is going\nto be placed here.\n* `LanguageYouLearnExplanation`.\nThis explanation will always accompany the word in the language you want to\nlearn.\nIt explains in what alternative forms the word can appear as synonyms or\nvariations in writing.\nDo not give any extra information that reveals the meaning of the word, as it\nwill appear on the front of some cards where your goal will be to make the\ntranslation into your language.\nFor example: English "hit, to punch someone" to Spanish "pegar, you can also\nuse \'golpear\'".\n* `Tags`.\nThe tags you write here are added to the tags specified in the\n`cards_config.json`.\n\n\nThis is how the fields are shown in the cards.\nFront card format:\n\n    YourLanguageWord\n    YourLanguageExplanation\n    ---                            # After showing answer\n    LanguageYouLearnWord           # After showing answer\n    LanguageYouLearnPronunciation  # After showing answer\n    LanguageYouLearnExplanation    # After showing answer\n\nReverse card format:\n\n    LanguageYouLearnWord\n    LanguageYouLearnPronunciation  # After showing answer\n    LanguageYouLearnExplanation\n    ---                            # After showing answer\n    YourLanguageWord               # After showing answer\n    YourLanguageExplanation        # After showing answer\n\nFor Japanese language there is an special flag in `cards_config.json` named\n`furigana`.\nIf you mark this flag to true the Kanjis in the front side are going to be\nshown alone and in the back side are going to be shown with furigana.\nThis makes the field `LanguageYouLearnPronunciation` not really required when\ncreating Japanese cards (you can always use romaji here, of course).\n\n## Autogenerate TSV files with `maketsv` command\n\nYou can use automatically generated `*.tsv` files for `autogenerated` type of\ncards instead of `*.txt` files. If you want to review automatically generated \ncards before collecting them in `apkg` file use this option.\n\nTo create such a file, move to the folder with the `*.txt` file with words you\nwant to turn into cards and execute command `mnemocards maketsv .`\n\nBy default command will search for file with the name `words.txt`, but you can\npoint it toward any file with additional argument `-w name_of_file.txt`.\n\nBy default the command will assume that words in the file in english language\nand translate them to spanish. To change language pair use argument\n`-l lang_lang` where first `lang` value is the language of words and second\n`lang` value is your language. Use language codes from [this page](https://py-googletrans.readthedocs.io/en/latest/#googletrans-languages)\n\nFor example, command to translate words from japanese to english, collected in\nthe file `japanese.txt` will look like this:\n```bash\n$ mnemocards maketsv -l ja_en -w japanese.txt\n```\n\nThe resulting file will have a name based on language pair, in the example case\nit will be `ja_en.tsv`.\n\nThe TSV-file will have the same structure as TSV vocabulary file described \n[above](#tsv-vocabulary-files). In fact, you can use this TSV-file with\n`vocabulary` type configs for building decks. But I reccomend to use them\nwith `autogenerate` type configs, since the file will have some basic html\nwhich is used to make cards look like Google Translate site.\n\nAfter TSV-file generated you can manually adjust values of the columns and then\nuse it for generating the deck.\n\nYou can access full help for `maketsv` command by using `mnemocards maketsv -h`\n\n## Expressions TSV files\n\nSimilarly to vocabulary TSV files, the expression TSV files contain:\nAt the moment, the columns **should be in the given order**.\n\n* `ID`\nCharacters that uniquely identify a note.\nThis number must be unique not only in the file but in the whole collection,\nthat is why we recommend using a UUID (a sequence of alphanumeric characters\nsuch as: 64012c71-9aea-4622-aac7-2595d6798737).\nHaving a UUID is necessary to be able to update the cards (make spelling\ncorrections or improve them with extra information) and not lose the progress.\nIf you need to generate UUID for your card when you first compose it, use \ncommand `mnemocards id`\n\n* `Expression`.\nExpression that you want to learn.\n* `Explanation`.\nExtra explanation of the expression if needed.\n* `Meaning`.\nMeaning of the expression.\n* `Example`.\nExample sentence of use of the expression.\n* `Tags`.\nThe tags you write here are added to the tags specified in the\n`cards_config.json`.\n\nThis type of notes only have one front card.\nFront card:\n\n    Expression\n    Explanation\n    ---          # After showing answer\n    Meaning      # After showing answer\n    Example      # After showing answer\n\nOf course, these types of cards are created for the purpose of learning a new\nlanguage, but they can be used for any other purpose as long as the fields\ndescribed here fit your purpose.\n\n\n# Import cards to Anki\n\nUse the command `mnemocards import --help` to get the instructions about\nimporting `*.apkg` files.\n\n```\n$ mnemocards import --help\nusage: mnemocards import [-h] [--profile-name PROFILE_NAME]\n                         [--collection-path COLLECTION_PATH]\n                         apkgs [apkgs ...]\n\npositional arguments:\n  apkgs                 List of packages to import.\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --profile-name PROFILE_NAME, -p PROFILE_NAME\n                        If your collection is in the default location\n                        (`~/.local/share/Anki2/`) you can specify only the\n                        profile name. You cannot use this option as the same\n                        time as `-c`.\n  --collection-path COLLECTION_PATH, -c COLLECTION_PATH\n                        Specify the full path of the collection file. If you\n                        use this option with `-p` (profile name), the profile\n                        name has preference over the full collection path.\n```\n\nTo import an `*.apkg` file you need to close Anki, otherwise the collection\nfile cannot be written.\nRemember that you need to open Anki and synchronize the collection with\nWeb Anki to see the updated collection in all your devices.\n\n\n# *Git* utilities\n\nIn order to keep my cards safe and centralize my knowledge database, I added a\nfew utilities to `mnemocards` to clone and push many *Git* repositories at\nthe same time.\n\nThe first step is to know which repositories you want to clone.\nI like to create a new private repository for every subject I\'m learning.\nFor example:\n\n * Japanese: under my profile I have a repository called `learning_japanese`.\n * Programming: I have a repository called `learning_programming`.\n * And so on...\n\nMy aim is to clone all these repositories in an easy way and make them very\naccessible so that any time I think of something I want to remember I don\'t\npostpone it because of laziness.\nAs I\'m always learning I have a lot of repositories.\nTo automate this task I\'ve created the `mnemocards github` command.\n\nThe result of executing the next command is a `~/.mnemocards` file with a list\nof all the repositories with Anki cards and the local path in my PC where I\nwant them to be cloned.\n```\n$ mnemocards github -i "guiferviz/learning_([^ _]*)" -d ~/learning\n... some output ...\n$ cat ~/.mnemocards\n{\n    "repos": [\n        [\n            "git@github.com:guiferviz/learning_japanese.git",\n            "~/learning/japanese"\n        ],\n        [\n            "git@github.com:guiferviz/learning_programming.git",\n            "~/learning/programming"\n        ]\n    ]\n}\n```\n\nTo execute that command you need a file with your GitHub API key with enough\npermissions to read your repositories.\nGo to [GitHub Tokens][githubTokens] and generate a new one with permissions\nfor reading your repositories.\nIf you want to read private repositories select the next permissions:\n\n![](doc/_static/images/github_api_permissions_01.png)\n\nIf you want to use the `mnemocards github --gists` option, that is, cloning\ngists instead of repositories, your GitHub API key should have different\npermissions.\nI do not use gists because they do not allow to commit directories and I want\nto have my images good organized.\n\n![](doc/_static/images/github_api_permissions_02.png)\n\nYou can also create the `~/.mnemocards` file by hand taking the given example\nand substituting the URLs and the local paths.\n\nOnce you have your file manually create or automatically created, you can\nclone all your repos with the next command.\nIf your repo is already cloned, this command also pulls the last changes from\nthe server.\n```\nmnemocards pull\n```\n\nTo commit and push all the changes in a repository use the next command.\nEverything in your repositories is going to be added and committed, so if you\ndo not want to include all the files add exclude patters in your `.gitignore`\nor push all your repositories manually.\nCommits are made using a default commit message similar to\n"Updating repository with mnemocards.".\n```\nmnemocards push\n```\n\n\n# Docker\n\nA *Docker* image is available so that you can generate your packages without\nhaving to install Mnemocards in your environment.\nAt the moment you need to have *Anki* installed locally.\nThe Docker image I\'ve built for you is named `guiferviz/mnemocards` and it\nis available in the [Mnemocards Docker Hub repository][dockerMnemocards].\nRead the documentation under the `docker/` directory to learn how to execute\nthe image.\n\nIf you want to generate the Docker image by your own, you will also find all\nthe information in the `docker/` directory (`Dockerfile` and build commands).\n\nAs Docker images are auto-generated when a new version tag is pushed to the\nGitHub repository, using Docker is a very convenient way to switch between\ndifferent versions of Mnemocards.\n\n\n# VIM users\n\nI\'m a die-hard VIM user, for that reason I\'ve created a `vim_syntax/cards.vim`\n**syntax file**.\nIt\'s not too fancy but it looks better than using the Markdown syntax.\n\nUsing Markdown syntax:\n<img src="doc/_static/images/vim_markdown_syntax.png" width="800">\n\nUsing my own Cards syntax:\n<img src="doc/_static/images/vim_cards_syntax.png" width="800">\n\nAmong my [UltiSnips][ultiSnips] **snippets** I have one that generates a new\ncard with an unique ID, a title and a body.\n```snippet\nsnippet card "Create a new card" b\n<<<\nid: `!p if not snip.c: snip.rv = get_uuid()`\n===\n# ${1}\n---\n${2}\n>>>\nendsnippet\n```\nThe `get_uuid` function is defined as:\n```python\ndef get_uuid():\n    """Get an UUID string. """\n\n    import uuid\n    return str(uuid.uuid4())\n```\n\nI also use the [Markdown Preview][markdownPreview] plugin so I can see **how my\ncards look like without generating the package**.\nIt\'s not perfect for the `*.cards` format, but it\'s better than nothing :)\n\n\n[markdownPreview]: https://github.com/iamcco/markdown-preview.nvim\n[ultiSnips]: https://github.com/SirVer/ultisnips\n[dockerMnemocards]: https://hub.docker.com/repository/docker/guiferviz/mnemocards \n[githubTokens]: https://github.com/settings/tokens/new\n[ankidroidDeckConfig]: https://github.com/ankidroid/Anki-Android/wiki/Database-Structure#dconf-jsonobjects\n[wikipediaIso2]: https://en.wikipedia.org/wiki/List_of_ISO_639-2_codes\n[genanki]: https://github.com/kerrickstaley/genanki\n\n',
    'author': 'guiferviz',
    'author_email': 'guiferviz@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/guiferviz/mnemocards',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
