# Frequently Asked Questions 🍂

![image](header.svg)

## What is the purpose of this project?

- This Project is an Authentication Package helping to Add a Fully registration
  and authentication or authorization system to your FastAPI project. Is
  designed to be as customizable and adaptable as possible, so that you can use
  it as you want.

  For example, you can use it to create a simple authentication system for your
  FastAPI project, Or Provide a Cache Service for your MicroService or API to
  store the data in a database using Redis and MongoDB.

## How to use this project?

- Reading the documentation is the best way to get started, but if you have any
  questions, please feel free to contact me, I will try as much as I can to help
  and provide some real world example.

## What is the difference between the [FastAPI-User](https://github.com/fastapi-users/fastapi-users) & AuthenticationX?

- First, I would like to thanks [François Voron](https://github.com/frankie567)
  For his FastAPI-Users Project he helped me to understand various things relate
  to authentication Systems, and Building a good, fast, scalable FastAPI
  application.

  Now for the difference, Here I provide more things that FastAPI-User have, for
  example:

  - Cache Services Using `Redis`.
  - Managing Social Authentication Using `httpX`.
  - Building a Helpful Addons like Captcha & String Checker.
  - Provide MongoDB as a Database.

    Lately, I see that FastAPI-User Provide more Databases Services and ORM For
    example `SQLAlchemy` and `MongoDB` and `PostgreSQL`.

    Anyway, Both Projects are very similar, but FastAPI-User is more
    customizable and easy to use, and AuthenticationX is more customizable and
    but it is more complex to use 🦥.

## How Did You Manage AuthX?

I use Trello Cards to Manage my work, check it here
[https://trello.com/b/0NNZMP8T/authx](https://trello.com/b/0NNZMP8T/authx).

## How to Support Project?

You can financially support the author (me) through
<a href="https://paypal.me/yassertahiri?locale.x=en_US" class="external-link" target="_blank">Paypal
sponsors</a>.

There you could buy me a [coffee ☕️](https://www.buymeacoffee.com/tahiri) to
say thanks. 😄

And you can also become a Silver or Gold sponsor for AuthX. 🏅🎉

### Basic References

I use the following reference to get The package done:

- <https://fastapi.tiangolo.com/>
- <https://frankie567.github.io/fastapi-users/>
- <https://indominusbyte.github.io/fastapi-jwt-auth/>
- <https://fastapi-crudrouter.awtkns.com/>
- <https://camillovisini.com/article/abstracting-fastapi-services/>
- <https://motor.readthedocs.io/en/stable/>
- <https://pyjwt.readthedocs.io/en/latest/>

## License

This project is licensed under the terms of the MIT License.
