from authx.backend.base import Base
from authx.core.config import EMAIL_CONFIRMATION_MAX, EMAIL_CONFIRMATION_TIMEOUT


class UsersConfirmMixin(Base):
    """User Confirmation MIXIN"""

    async def is_email_confirmation_available(self, id: int) -> bool:
        key = f"users:confirm:count:{id}"
        return await self._check_timeout_and_incr(
            key, EMAIL_CONFIRMATION_MAX, EMAIL_CONFIRMATION_TIMEOUT
        )

    async def request_email_confirmation(self, email: str, token_hash: str) -> None:
        await self._database.request_email_confirmation(email, token_hash)
        return None

    async def confirm_email(self, token_hash: str) -> bool:
        return await self._database.confirm_email(token_hash)
