# Multi-controller supervisor library
Модуль для контроля сети H802RA узлов.

[![Tests](https://github.com/mserg/ledmx-lib/actions/workflows/tests.yaml/badge.svg)](https://github.com/mserg/ledmx-lib/actions/workflows/tests.yaml)

Протокол управления - [Art-Net (pdf)](docs/art-net.pdf)

Контроллер - [H802RA (pdf)](docs/H802RA%20instructions%20-%20English.pdf)

Лента - [WS2813 (pdf)](docs/WS2813-Worldsemi.pdf)

## Как это работает
На основе конфига строится экземпляр класса мультивселенная, объединяющего
данные всех вселенных в сети, карту пикселей (словарь по глобальному номеру пикселя и его данным) и 
методы для модификации данных по номеру пикселя и формирования и отправки ArtDMX пакетов.

![](docs/scheme.png)

При изменении значения байт конкретного пикселя, данные по ссылке меняются в глобальной матрице
вселенных.
При публикации данных (метод `multiverse.pub()`), данные вселенных преобразуются в ArtDMX пакеты и 
отправляются по указанному адресу.

## Конфигурация

Конфиг - в формате [yaml](https://ru.wikipedia.org/wiki/YAML).

Корневой объект `nodes` содержит список узлов, каждый узел описан:
- адресом хоста (куда слать ArtDMX пакет)
- именем
- словарём выходов
  - ключ: номер выхода на узле (с нуля)
  - значение: строка с указанием диапазонов номеров пикселей

Пиксели нумеруются глобально с нуля.

Пример:
```yaml

nodes:
# узел "box"
  - host: 10.0.0.10     # адрес хоста (IP или DNS имя)
    name: box           # имя узла
    outs:               # разметка пикселей по выходам
      0: 0-300          # в 0-м выходе - пиксели с 0-го по 300-й (искл.)
      1: 300-600        # в 1-м выходе - пиксели с 300-го по 600-й

  - host: 10.0.0.11
    name: node-1
    outs:
      0: 901, 1001-1010
      1: 600 - 725
                        # пустые выходы можно пропустить
      3: 725- 800,1015  # диапазоны можно разделять запятой, можно указывать одиночные пиксели 

  - host: 10.0.0.12
    name: j-50
    outs:
      2: 800-850

  - host: 10.0.0.13
    name: tail
    outs:
      1: 1016-1028
      3: 1062
      7: 850-900, 910, 911  # число выходов может быть разным на разныз узлах (тут - 8-портовый узел)
```

Подробнее - в комментариях к коду.

## Запуск тестов
```bash
flake8 . --show-source --statistics --max-line-length=127
python -m pytest .
```

## Использование
конф:
```yaml
---
nodes:
  - host: 10.0.0.10
    name: box
    outs:
      0: 0-300
      1: 300-600
```

скрипт:
```python
# импорт класса мультивселенной
from ledmx.multiverse import Multiverse

# импорт функции парсинга конфига
from ledmx.layout import parse_file

if __name__ == '__main__':

# загружаем конфиг
    layout = parse_file('layout.yaml')
    
# формируем мультивселенную
    m_verse = Multiverse(layout)
    
# задаём значения цвета (GBR) для пикселей по их глобальным id
    m_verse[245] = 100, 10, 10
    m_verse[308] = 5, 100, 40
    
# формируем из матрицы пакеты и рассылем их
    m_verse.pub()
```
