# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ncbi.datasets.openapi.configuration import Configuration


class V1Range(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'begin': 'str',
        'end': 'str',
        'order': 'int',
        'orientation': 'V1Orientation',
        'ribosomal_slippage': 'int'
    }

    attribute_map = {
        'begin': 'begin',
        'end': 'end',
        'order': 'order',
        'orientation': 'orientation',
        'ribosomal_slippage': 'ribosomal_slippage'
    }

    def __init__(self, begin=None, end=None, order=None, orientation=None, ribosomal_slippage=None, local_vars_configuration=None):  # noqa: E501
        """V1Range - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._begin = None
        self._end = None
        self._order = None
        self._orientation = None
        self._ribosomal_slippage = None
        self.discriminator = None

        if begin is not None:
            self.begin = begin
        if end is not None:
            self.end = end
        if order is not None:
            self.order = order
        if orientation is not None:
            self.orientation = orientation
        if ribosomal_slippage is not None:
            self.ribosomal_slippage = ribosomal_slippage

    @property
    def begin(self):
        """Gets the begin of this V1Range.  # noqa: E501


        :return: The begin of this V1Range.  # noqa: E501
        :rtype: str
        """
        return self._begin

    @begin.setter
    def begin(self, begin):
        """Sets the begin of this V1Range.


        :param begin: The begin of this V1Range.  # noqa: E501
        :type: str
        """

        self._begin = begin

    @property
    def end(self):
        """Gets the end of this V1Range.  # noqa: E501


        :return: The end of this V1Range.  # noqa: E501
        :rtype: str
        """
        return self._end

    @end.setter
    def end(self, end):
        """Sets the end of this V1Range.


        :param end: The end of this V1Range.  # noqa: E501
        :type: str
        """

        self._end = end

    @property
    def order(self):
        """Gets the order of this V1Range.  # noqa: E501

        When an ordering is desired, fill out the order in the range.  # noqa: E501

        :return: The order of this V1Range.  # noqa: E501
        :rtype: int
        """
        return self._order

    @order.setter
    def order(self, order):
        """Sets the order of this V1Range.

        When an ordering is desired, fill out the order in the range.  # noqa: E501

        :param order: The order of this V1Range.  # noqa: E501
        :type: int
        """

        self._order = order

    @property
    def orientation(self):
        """Gets the orientation of this V1Range.  # noqa: E501


        :return: The orientation of this V1Range.  # noqa: E501
        :rtype: V1Orientation
        """
        return self._orientation

    @orientation.setter
    def orientation(self, orientation):
        """Sets the orientation of this V1Range.


        :param orientation: The orientation of this V1Range.  # noqa: E501
        :type: V1Orientation
        """

        self._orientation = orientation

    @property
    def ribosomal_slippage(self):
        """Gets the ribosomal_slippage of this V1Range.  # noqa: E501

        When ribosomal slippage is desired, fill out slippage amount between this and previous range.  # noqa: E501

        :return: The ribosomal_slippage of this V1Range.  # noqa: E501
        :rtype: int
        """
        return self._ribosomal_slippage

    @ribosomal_slippage.setter
    def ribosomal_slippage(self, ribosomal_slippage):
        """Sets the ribosomal_slippage of this V1Range.

        When ribosomal slippage is desired, fill out slippage amount between this and previous range.  # noqa: E501

        :param ribosomal_slippage: The ribosomal_slippage of this V1Range.  # noqa: E501
        :type: int
        """

        self._ribosomal_slippage = ribosomal_slippage

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1Range):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1Range):
            return True

        return self.to_dict() != other.to_dict()
