# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ncbi.datasets.openapi.configuration import Configuration


class V1GeneMatch(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'errors': 'list[V1Error]',
        'gene': 'V1GeneDescriptor',
        'messages': 'list[V1Message]',
        'query': 'list[str]',
        'warnings': 'list[V1Warning]'
    }

    attribute_map = {
        'errors': 'errors',
        'gene': 'gene',
        'messages': 'messages',
        'query': 'query',
        'warnings': 'warnings'
    }

    def __init__(self, errors=None, gene=None, messages=None, query=None, warnings=None, local_vars_configuration=None):  # noqa: E501
        """V1GeneMatch - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._errors = None
        self._gene = None
        self._messages = None
        self._query = None
        self._warnings = None
        self.discriminator = None

        if errors is not None:
            self.errors = errors
        if gene is not None:
            self.gene = gene
        if messages is not None:
            self.messages = messages
        if query is not None:
            self.query = query
        if warnings is not None:
            self.warnings = warnings

    @property
    def errors(self):
        """Gets the errors of this V1GeneMatch.  # noqa: E501


        :return: The errors of this V1GeneMatch.  # noqa: E501
        :rtype: list[V1Error]
        """
        return self._errors

    @errors.setter
    def errors(self, errors):
        """Sets the errors of this V1GeneMatch.


        :param errors: The errors of this V1GeneMatch.  # noqa: E501
        :type: list[V1Error]
        """

        self._errors = errors

    @property
    def gene(self):
        """Gets the gene of this V1GeneMatch.  # noqa: E501


        :return: The gene of this V1GeneMatch.  # noqa: E501
        :rtype: V1GeneDescriptor
        """
        return self._gene

    @gene.setter
    def gene(self, gene):
        """Sets the gene of this V1GeneMatch.


        :param gene: The gene of this V1GeneMatch.  # noqa: E501
        :type: V1GeneDescriptor
        """

        self._gene = gene

    @property
    def messages(self):
        """Gets the messages of this V1GeneMatch.  # noqa: E501


        :return: The messages of this V1GeneMatch.  # noqa: E501
        :rtype: list[V1Message]
        """
        return self._messages

    @messages.setter
    def messages(self, messages):
        """Sets the messages of this V1GeneMatch.


        :param messages: The messages of this V1GeneMatch.  # noqa: E501
        :type: list[V1Message]
        """

        self._messages = messages

    @property
    def query(self):
        """Gets the query of this V1GeneMatch.  # noqa: E501


        :return: The query of this V1GeneMatch.  # noqa: E501
        :rtype: list[str]
        """
        return self._query

    @query.setter
    def query(self, query):
        """Sets the query of this V1GeneMatch.


        :param query: The query of this V1GeneMatch.  # noqa: E501
        :type: list[str]
        """

        self._query = query

    @property
    def warnings(self):
        """Gets the warnings of this V1GeneMatch.  # noqa: E501


        :return: The warnings of this V1GeneMatch.  # noqa: E501
        :rtype: list[V1Warning]
        """
        return self._warnings

    @warnings.setter
    def warnings(self, warnings):
        """Sets the warnings of this V1GeneMatch.


        :param warnings: The warnings of this V1GeneMatch.  # noqa: E501
        :type: list[V1Warning]
        """

        self._warnings = warnings

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1GeneMatch):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1GeneMatch):
            return True

        return self.to_dict() != other.to_dict()
