# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ncbi.datasets.openapi.configuration import Configuration


class V1BuscoStat(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'busco_lineage': 'str',
        'busco_ver': 'str',
        'complete': 'float',
        'duplicated': 'float',
        'fragmented': 'float',
        'missing': 'float',
        'single_copy': 'float',
        'total_count': 'str'
    }

    attribute_map = {
        'busco_lineage': 'busco_lineage',
        'busco_ver': 'busco_ver',
        'complete': 'complete',
        'duplicated': 'duplicated',
        'fragmented': 'fragmented',
        'missing': 'missing',
        'single_copy': 'single_copy',
        'total_count': 'total_count'
    }

    def __init__(self, busco_lineage=None, busco_ver=None, complete=None, duplicated=None, fragmented=None, missing=None, single_copy=None, total_count=None, local_vars_configuration=None):  # noqa: E501
        """V1BuscoStat - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._busco_lineage = None
        self._busco_ver = None
        self._complete = None
        self._duplicated = None
        self._fragmented = None
        self._missing = None
        self._single_copy = None
        self._total_count = None
        self.discriminator = None

        if busco_lineage is not None:
            self.busco_lineage = busco_lineage
        if busco_ver is not None:
            self.busco_ver = busco_ver
        if complete is not None:
            self.complete = complete
        if duplicated is not None:
            self.duplicated = duplicated
        if fragmented is not None:
            self.fragmented = fragmented
        if missing is not None:
            self.missing = missing
        if single_copy is not None:
            self.single_copy = single_copy
        if total_count is not None:
            self.total_count = total_count

    @property
    def busco_lineage(self):
        """Gets the busco_lineage of this V1BuscoStat.  # noqa: E501


        :return: The busco_lineage of this V1BuscoStat.  # noqa: E501
        :rtype: str
        """
        return self._busco_lineage

    @busco_lineage.setter
    def busco_lineage(self, busco_lineage):
        """Sets the busco_lineage of this V1BuscoStat.


        :param busco_lineage: The busco_lineage of this V1BuscoStat.  # noqa: E501
        :type: str
        """

        self._busco_lineage = busco_lineage

    @property
    def busco_ver(self):
        """Gets the busco_ver of this V1BuscoStat.  # noqa: E501


        :return: The busco_ver of this V1BuscoStat.  # noqa: E501
        :rtype: str
        """
        return self._busco_ver

    @busco_ver.setter
    def busco_ver(self, busco_ver):
        """Sets the busco_ver of this V1BuscoStat.


        :param busco_ver: The busco_ver of this V1BuscoStat.  # noqa: E501
        :type: str
        """

        self._busco_ver = busco_ver

    @property
    def complete(self):
        """Gets the complete of this V1BuscoStat.  # noqa: E501


        :return: The complete of this V1BuscoStat.  # noqa: E501
        :rtype: float
        """
        return self._complete

    @complete.setter
    def complete(self, complete):
        """Sets the complete of this V1BuscoStat.


        :param complete: The complete of this V1BuscoStat.  # noqa: E501
        :type: float
        """

        self._complete = complete

    @property
    def duplicated(self):
        """Gets the duplicated of this V1BuscoStat.  # noqa: E501


        :return: The duplicated of this V1BuscoStat.  # noqa: E501
        :rtype: float
        """
        return self._duplicated

    @duplicated.setter
    def duplicated(self, duplicated):
        """Sets the duplicated of this V1BuscoStat.


        :param duplicated: The duplicated of this V1BuscoStat.  # noqa: E501
        :type: float
        """

        self._duplicated = duplicated

    @property
    def fragmented(self):
        """Gets the fragmented of this V1BuscoStat.  # noqa: E501


        :return: The fragmented of this V1BuscoStat.  # noqa: E501
        :rtype: float
        """
        return self._fragmented

    @fragmented.setter
    def fragmented(self, fragmented):
        """Sets the fragmented of this V1BuscoStat.


        :param fragmented: The fragmented of this V1BuscoStat.  # noqa: E501
        :type: float
        """

        self._fragmented = fragmented

    @property
    def missing(self):
        """Gets the missing of this V1BuscoStat.  # noqa: E501


        :return: The missing of this V1BuscoStat.  # noqa: E501
        :rtype: float
        """
        return self._missing

    @missing.setter
    def missing(self, missing):
        """Sets the missing of this V1BuscoStat.


        :param missing: The missing of this V1BuscoStat.  # noqa: E501
        :type: float
        """

        self._missing = missing

    @property
    def single_copy(self):
        """Gets the single_copy of this V1BuscoStat.  # noqa: E501


        :return: The single_copy of this V1BuscoStat.  # noqa: E501
        :rtype: float
        """
        return self._single_copy

    @single_copy.setter
    def single_copy(self, single_copy):
        """Sets the single_copy of this V1BuscoStat.


        :param single_copy: The single_copy of this V1BuscoStat.  # noqa: E501
        :type: float
        """

        self._single_copy = single_copy

    @property
    def total_count(self):
        """Gets the total_count of this V1BuscoStat.  # noqa: E501


        :return: The total_count of this V1BuscoStat.  # noqa: E501
        :rtype: str
        """
        return self._total_count

    @total_count.setter
    def total_count(self, total_count):
        """Sets the total_count of this V1BuscoStat.


        :param total_count: The total_count of this V1BuscoStat.  # noqa: E501
        :type: str
        """

        self._total_count = total_count

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1BuscoStat):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1BuscoStat):
            return True

        return self.to_dict() != other.to_dict()
