# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ncbi.datasets.openapi.configuration import Configuration


class V1AssemblyDatasetRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'accessions': 'list[str]',
        'assembly_accessions': 'list[str]',
        'chromosomes': 'list[str]',
        'exclude_sequence': 'bool',
        'hydrated': 'AssemblyDatasetRequestResolution',
        'include_annotation': 'bool',
        'include_annotation_type': 'list[V1AnnotationForAssemblyType]',
        'include_tsv': 'bool'
    }

    attribute_map = {
        'accessions': 'accessions',
        'assembly_accessions': 'assembly_accessions',
        'chromosomes': 'chromosomes',
        'exclude_sequence': 'exclude_sequence',
        'hydrated': 'hydrated',
        'include_annotation': 'include_annotation',
        'include_annotation_type': 'include_annotation_type',
        'include_tsv': 'include_tsv'
    }

    def __init__(self, accessions=None, assembly_accessions=None, chromosomes=None, exclude_sequence=None, hydrated=None, include_annotation=None, include_annotation_type=None, include_tsv=None, local_vars_configuration=None):  # noqa: E501
        """V1AssemblyDatasetRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._accessions = None
        self._assembly_accessions = None
        self._chromosomes = None
        self._exclude_sequence = None
        self._hydrated = None
        self._include_annotation = None
        self._include_annotation_type = None
        self._include_tsv = None
        self.discriminator = None

        if accessions is not None:
            self.accessions = accessions
        if assembly_accessions is not None:
            self.assembly_accessions = assembly_accessions
        if chromosomes is not None:
            self.chromosomes = chromosomes
        if exclude_sequence is not None:
            self.exclude_sequence = exclude_sequence
        if hydrated is not None:
            self.hydrated = hydrated
        if include_annotation is not None:
            self.include_annotation = include_annotation
        if include_annotation_type is not None:
            self.include_annotation_type = include_annotation_type
        if include_tsv is not None:
            self.include_tsv = include_tsv

    @property
    def accessions(self):
        """Gets the accessions of this V1AssemblyDatasetRequest.  # noqa: E501


        :return: The accessions of this V1AssemblyDatasetRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._accessions

    @accessions.setter
    def accessions(self, accessions):
        """Sets the accessions of this V1AssemblyDatasetRequest.


        :param accessions: The accessions of this V1AssemblyDatasetRequest.  # noqa: E501
        :type: list[str]
        """

        self._accessions = accessions

    @property
    def assembly_accessions(self):
        """Gets the assembly_accessions of this V1AssemblyDatasetRequest.  # noqa: E501


        :return: The assembly_accessions of this V1AssemblyDatasetRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._assembly_accessions

    @assembly_accessions.setter
    def assembly_accessions(self, assembly_accessions):
        """Sets the assembly_accessions of this V1AssemblyDatasetRequest.


        :param assembly_accessions: The assembly_accessions of this V1AssemblyDatasetRequest.  # noqa: E501
        :type: list[str]
        """

        self._assembly_accessions = assembly_accessions

    @property
    def chromosomes(self):
        """Gets the chromosomes of this V1AssemblyDatasetRequest.  # noqa: E501

        The default setting is all chromosome. Specify individual chromosome by string (1,2,MT or chr1,chr2.chrMT). Unplaced sequences are treated like their own chromosome ('Un'). The filter only applies to fasta sequence.  # noqa: E501

        :return: The chromosomes of this V1AssemblyDatasetRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._chromosomes

    @chromosomes.setter
    def chromosomes(self, chromosomes):
        """Sets the chromosomes of this V1AssemblyDatasetRequest.

        The default setting is all chromosome. Specify individual chromosome by string (1,2,MT or chr1,chr2.chrMT). Unplaced sequences are treated like their own chromosome ('Un'). The filter only applies to fasta sequence.  # noqa: E501

        :param chromosomes: The chromosomes of this V1AssemblyDatasetRequest.  # noqa: E501
        :type: list[str]
        """

        self._chromosomes = chromosomes

    @property
    def exclude_sequence(self):
        """Gets the exclude_sequence of this V1AssemblyDatasetRequest.  # noqa: E501

        Set to true to omit the genomic sequence.  # noqa: E501

        :return: The exclude_sequence of this V1AssemblyDatasetRequest.  # noqa: E501
        :rtype: bool
        """
        return self._exclude_sequence

    @exclude_sequence.setter
    def exclude_sequence(self, exclude_sequence):
        """Sets the exclude_sequence of this V1AssemblyDatasetRequest.

        Set to true to omit the genomic sequence.  # noqa: E501

        :param exclude_sequence: The exclude_sequence of this V1AssemblyDatasetRequest.  # noqa: E501
        :type: bool
        """

        self._exclude_sequence = exclude_sequence

    @property
    def hydrated(self):
        """Gets the hydrated of this V1AssemblyDatasetRequest.  # noqa: E501


        :return: The hydrated of this V1AssemblyDatasetRequest.  # noqa: E501
        :rtype: AssemblyDatasetRequestResolution
        """
        return self._hydrated

    @hydrated.setter
    def hydrated(self, hydrated):
        """Sets the hydrated of this V1AssemblyDatasetRequest.


        :param hydrated: The hydrated of this V1AssemblyDatasetRequest.  # noqa: E501
        :type: AssemblyDatasetRequestResolution
        """

        self._hydrated = hydrated

    @property
    def include_annotation(self):
        """Gets the include_annotation of this V1AssemblyDatasetRequest.  # noqa: E501


        :return: The include_annotation of this V1AssemblyDatasetRequest.  # noqa: E501
        :rtype: bool
        """
        return self._include_annotation

    @include_annotation.setter
    def include_annotation(self, include_annotation):
        """Sets the include_annotation of this V1AssemblyDatasetRequest.


        :param include_annotation: The include_annotation of this V1AssemblyDatasetRequest.  # noqa: E501
        :type: bool
        """

        self._include_annotation = include_annotation

    @property
    def include_annotation_type(self):
        """Gets the include_annotation_type of this V1AssemblyDatasetRequest.  # noqa: E501

        Select additional types of annotation to include in the data package.  If unset, no annotation is provided.  # noqa: E501

        :return: The include_annotation_type of this V1AssemblyDatasetRequest.  # noqa: E501
        :rtype: list[V1AnnotationForAssemblyType]
        """
        return self._include_annotation_type

    @include_annotation_type.setter
    def include_annotation_type(self, include_annotation_type):
        """Sets the include_annotation_type of this V1AssemblyDatasetRequest.

        Select additional types of annotation to include in the data package.  If unset, no annotation is provided.  # noqa: E501

        :param include_annotation_type: The include_annotation_type of this V1AssemblyDatasetRequest.  # noqa: E501
        :type: list[V1AnnotationForAssemblyType]
        """

        self._include_annotation_type = include_annotation_type

    @property
    def include_tsv(self):
        """Gets the include_tsv of this V1AssemblyDatasetRequest.  # noqa: E501

        Set to true to include a TSV represention of the data-report.  # noqa: E501

        :return: The include_tsv of this V1AssemblyDatasetRequest.  # noqa: E501
        :rtype: bool
        """
        return self._include_tsv

    @include_tsv.setter
    def include_tsv(self, include_tsv):
        """Sets the include_tsv of this V1AssemblyDatasetRequest.

        Set to true to include a TSV represention of the data-report.  # noqa: E501

        :param include_tsv: The include_tsv of this V1AssemblyDatasetRequest.  # noqa: E501
        :type: bool
        """

        self._include_tsv = include_tsv

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1AssemblyDatasetRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1AssemblyDatasetRequest):
            return True

        return self.to_dict() != other.to_dict()
