# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ncbi.datasets.openapi.configuration import Configuration


class V1AssemblyDatasetDescriptor(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'annotation_metadata': 'V1AnnotationForAssembly',
        'assembly_accession': 'str',
        'assembly_category': 'str',
        'assembly_level': 'str',
        'bioproject_lineages': 'list[V1BioProjectLineage]',
        'biosample_accession': 'str',
        'blast_url': 'str',
        'chromosomes': 'list[AssemblyDatasetDescriptorChromosome]',
        'contig_n50': 'int',
        'display_name': 'str',
        'estimated_size': 'str',
        'org': 'V1Organism',
        'paired_assembly_accession': 'str',
        'seq_length': 'str',
        'submission_date': 'str',
        'submitter': 'str'
    }

    attribute_map = {
        'annotation_metadata': 'annotation_metadata',
        'assembly_accession': 'assembly_accession',
        'assembly_category': 'assembly_category',
        'assembly_level': 'assembly_level',
        'bioproject_lineages': 'bioproject_lineages',
        'biosample_accession': 'biosample_accession',
        'blast_url': 'blast_url',
        'chromosomes': 'chromosomes',
        'contig_n50': 'contig_n50',
        'display_name': 'display_name',
        'estimated_size': 'estimated_size',
        'org': 'org',
        'paired_assembly_accession': 'paired_assembly_accession',
        'seq_length': 'seq_length',
        'submission_date': 'submission_date',
        'submitter': 'submitter'
    }

    def __init__(self, annotation_metadata=None, assembly_accession=None, assembly_category=None, assembly_level=None, bioproject_lineages=None, biosample_accession=None, blast_url=None, chromosomes=None, contig_n50=None, display_name=None, estimated_size=None, org=None, paired_assembly_accession=None, seq_length=None, submission_date=None, submitter=None, local_vars_configuration=None):  # noqa: E501
        """V1AssemblyDatasetDescriptor - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._annotation_metadata = None
        self._assembly_accession = None
        self._assembly_category = None
        self._assembly_level = None
        self._bioproject_lineages = None
        self._biosample_accession = None
        self._blast_url = None
        self._chromosomes = None
        self._contig_n50 = None
        self._display_name = None
        self._estimated_size = None
        self._org = None
        self._paired_assembly_accession = None
        self._seq_length = None
        self._submission_date = None
        self._submitter = None
        self.discriminator = None

        if annotation_metadata is not None:
            self.annotation_metadata = annotation_metadata
        if assembly_accession is not None:
            self.assembly_accession = assembly_accession
        if assembly_category is not None:
            self.assembly_category = assembly_category
        if assembly_level is not None:
            self.assembly_level = assembly_level
        if bioproject_lineages is not None:
            self.bioproject_lineages = bioproject_lineages
        if biosample_accession is not None:
            self.biosample_accession = biosample_accession
        if blast_url is not None:
            self.blast_url = blast_url
        if chromosomes is not None:
            self.chromosomes = chromosomes
        if contig_n50 is not None:
            self.contig_n50 = contig_n50
        if display_name is not None:
            self.display_name = display_name
        if estimated_size is not None:
            self.estimated_size = estimated_size
        if org is not None:
            self.org = org
        if paired_assembly_accession is not None:
            self.paired_assembly_accession = paired_assembly_accession
        if seq_length is not None:
            self.seq_length = seq_length
        if submission_date is not None:
            self.submission_date = submission_date
        if submitter is not None:
            self.submitter = submitter

    @property
    def annotation_metadata(self):
        """Gets the annotation_metadata of this V1AssemblyDatasetDescriptor.  # noqa: E501


        :return: The annotation_metadata of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: V1AnnotationForAssembly
        """
        return self._annotation_metadata

    @annotation_metadata.setter
    def annotation_metadata(self, annotation_metadata):
        """Sets the annotation_metadata of this V1AssemblyDatasetDescriptor.


        :param annotation_metadata: The annotation_metadata of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :type: V1AnnotationForAssembly
        """

        self._annotation_metadata = annotation_metadata

    @property
    def assembly_accession(self):
        """Gets the assembly_accession of this V1AssemblyDatasetDescriptor.  # noqa: E501


        :return: The assembly_accession of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._assembly_accession

    @assembly_accession.setter
    def assembly_accession(self, assembly_accession):
        """Sets the assembly_accession of this V1AssemblyDatasetDescriptor.


        :param assembly_accession: The assembly_accession of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :type: str
        """

        self._assembly_accession = assembly_accession

    @property
    def assembly_category(self):
        """Gets the assembly_category of this V1AssemblyDatasetDescriptor.  # noqa: E501

        Category of assembly, like reference.  # noqa: E501

        :return: The assembly_category of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._assembly_category

    @assembly_category.setter
    def assembly_category(self, assembly_category):
        """Sets the assembly_category of this V1AssemblyDatasetDescriptor.

        Category of assembly, like reference.  # noqa: E501

        :param assembly_category: The assembly_category of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :type: str
        """

        self._assembly_category = assembly_category

    @property
    def assembly_level(self):
        """Gets the assembly_level of this V1AssemblyDatasetDescriptor.  # noqa: E501


        :return: The assembly_level of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._assembly_level

    @assembly_level.setter
    def assembly_level(self, assembly_level):
        """Sets the assembly_level of this V1AssemblyDatasetDescriptor.


        :param assembly_level: The assembly_level of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :type: str
        """

        self._assembly_level = assembly_level

    @property
    def bioproject_lineages(self):
        """Gets the bioproject_lineages of this V1AssemblyDatasetDescriptor.  # noqa: E501


        :return: The bioproject_lineages of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: list[V1BioProjectLineage]
        """
        return self._bioproject_lineages

    @bioproject_lineages.setter
    def bioproject_lineages(self, bioproject_lineages):
        """Sets the bioproject_lineages of this V1AssemblyDatasetDescriptor.


        :param bioproject_lineages: The bioproject_lineages of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :type: list[V1BioProjectLineage]
        """

        self._bioproject_lineages = bioproject_lineages

    @property
    def biosample_accession(self):
        """Gets the biosample_accession of this V1AssemblyDatasetDescriptor.  # noqa: E501

        NCBI BioSample Accession for the BioSample from which the sequences in the genome assembly were obtained.  # noqa: E501

        :return: The biosample_accession of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._biosample_accession

    @biosample_accession.setter
    def biosample_accession(self, biosample_accession):
        """Sets the biosample_accession of this V1AssemblyDatasetDescriptor.

        NCBI BioSample Accession for the BioSample from which the sequences in the genome assembly were obtained.  # noqa: E501

        :param biosample_accession: The biosample_accession of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :type: str
        """

        self._biosample_accession = biosample_accession

    @property
    def blast_url(self):
        """Gets the blast_url of this V1AssemblyDatasetDescriptor.  # noqa: E501


        :return: The blast_url of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._blast_url

    @blast_url.setter
    def blast_url(self, blast_url):
        """Sets the blast_url of this V1AssemblyDatasetDescriptor.


        :param blast_url: The blast_url of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :type: str
        """

        self._blast_url = blast_url

    @property
    def chromosomes(self):
        """Gets the chromosomes of this V1AssemblyDatasetDescriptor.  # noqa: E501

        Which chromosomes are included in this dataset. NB: Mitochondria is encoded as 'MT'.  # noqa: E501

        :return: The chromosomes of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: list[AssemblyDatasetDescriptorChromosome]
        """
        return self._chromosomes

    @chromosomes.setter
    def chromosomes(self, chromosomes):
        """Sets the chromosomes of this V1AssemblyDatasetDescriptor.

        Which chromosomes are included in this dataset. NB: Mitochondria is encoded as 'MT'.  # noqa: E501

        :param chromosomes: The chromosomes of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :type: list[AssemblyDatasetDescriptorChromosome]
        """

        self._chromosomes = chromosomes

    @property
    def contig_n50(self):
        """Gets the contig_n50 of this V1AssemblyDatasetDescriptor.  # noqa: E501


        :return: The contig_n50 of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: int
        """
        return self._contig_n50

    @contig_n50.setter
    def contig_n50(self, contig_n50):
        """Sets the contig_n50 of this V1AssemblyDatasetDescriptor.


        :param contig_n50: The contig_n50 of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :type: int
        """

        self._contig_n50 = contig_n50

    @property
    def display_name(self):
        """Gets the display_name of this V1AssemblyDatasetDescriptor.  # noqa: E501

        The name of the Assembly dataset to be displayed in a user interface.  # noqa: E501

        :return: The display_name of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this V1AssemblyDatasetDescriptor.

        The name of the Assembly dataset to be displayed in a user interface.  # noqa: E501

        :param display_name: The display_name of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :type: str
        """

        self._display_name = display_name

    @property
    def estimated_size(self):
        """Gets the estimated_size of this V1AssemblyDatasetDescriptor.  # noqa: E501


        :return: The estimated_size of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._estimated_size

    @estimated_size.setter
    def estimated_size(self, estimated_size):
        """Sets the estimated_size of this V1AssemblyDatasetDescriptor.


        :param estimated_size: The estimated_size of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :type: str
        """

        self._estimated_size = estimated_size

    @property
    def org(self):
        """Gets the org of this V1AssemblyDatasetDescriptor.  # noqa: E501


        :return: The org of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: V1Organism
        """
        return self._org

    @org.setter
    def org(self, org):
        """Sets the org of this V1AssemblyDatasetDescriptor.


        :param org: The org of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :type: V1Organism
        """

        self._org = org

    @property
    def paired_assembly_accession(self):
        """Gets the paired_assembly_accession of this V1AssemblyDatasetDescriptor.  # noqa: E501


        :return: The paired_assembly_accession of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._paired_assembly_accession

    @paired_assembly_accession.setter
    def paired_assembly_accession(self, paired_assembly_accession):
        """Sets the paired_assembly_accession of this V1AssemblyDatasetDescriptor.


        :param paired_assembly_accession: The paired_assembly_accession of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :type: str
        """

        self._paired_assembly_accession = paired_assembly_accession

    @property
    def seq_length(self):
        """Gets the seq_length of this V1AssemblyDatasetDescriptor.  # noqa: E501


        :return: The seq_length of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._seq_length

    @seq_length.setter
    def seq_length(self, seq_length):
        """Sets the seq_length of this V1AssemblyDatasetDescriptor.


        :param seq_length: The seq_length of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :type: str
        """

        self._seq_length = seq_length

    @property
    def submission_date(self):
        """Gets the submission_date of this V1AssemblyDatasetDescriptor.  # noqa: E501


        :return: The submission_date of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._submission_date

    @submission_date.setter
    def submission_date(self, submission_date):
        """Sets the submission_date of this V1AssemblyDatasetDescriptor.


        :param submission_date: The submission_date of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :type: str
        """

        self._submission_date = submission_date

    @property
    def submitter(self):
        """Gets the submitter of this V1AssemblyDatasetDescriptor.  # noqa: E501


        :return: The submitter of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._submitter

    @submitter.setter
    def submitter(self, submitter):
        """Sets the submitter of this V1AssemblyDatasetDescriptor.


        :param submitter: The submitter of this V1AssemblyDatasetDescriptor.  # noqa: E501
        :type: str
        """

        self._submitter = submitter

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1AssemblyDatasetDescriptor):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1AssemblyDatasetDescriptor):
            return True

        return self.to_dict() != other.to_dict()
