# Generated by Django 4.2.4 on 2023-09-20 08:16
from gettext import gettext

import swapper
from django.db import migrations, models

from django_project_base.constants import SEND_NOTIFICATION_SMS


def forwards_func(apps, schema_editor):
    project_sett = swapper.load_model("django_project_base", "ProjectSettings")
    for project in swapper.load_model("django_project_base", "Project").objects.all():
        project_sett.objects.get_or_create(
            project=project,
            name=SEND_NOTIFICATION_SMS,
            defaults=dict(
                description=gettext("Text for notification detail view. __LINK__ is url placeholder."),
                value=gettext("You received a notification. Clik link to view it: __LINK__"),
                value_type="char",
            ),
        )


def reverse_func(apps, schema_editor):
    pass


class Migration(migrations.Migration):
    dependencies = [
        ("notifications", "0005_merge_20230906_1213"),
    ]

    operations = [
        migrations.AddField(
            model_name="djangoprojectbasenotification",
            name="send_notification_sms",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="djangoprojectbasenotification",
            name="send_notification_sms_text",
            field=models.TextField(blank=False, null=True),
        ),
        migrations.RunPython(forwards_func, reverse_func),
    ]
