# Generated by Django 4.2.4 on 2023-09-06 12:13
import swapper
import random
import string
from django.db import migrations


def forwards_func(apps, schema_editor):
    from django_project_base.notifications.base.channels.integrations.t2 import T2

    ProjectModel = swapper.load_model("django_project_base", "Project")
    ProjectModelSettings = swapper.load_model("django_project_base", "ProjectSettings")
    t2 = T2()
    username = t2.delivery_report_username_setting_name
    passwd = t2.delivery_report_password_setting_name
    for project in ProjectModel.objects.all():
        ProjectModelSettings.objects.create(
            name=username,
            project=project,
            description="T2 username for DLR user",
            value=f"t2-{project.slug}-username",
            value_type="char",
        )

        ProjectModelSettings.objects.create(
            name=passwd,
            project=project,
            description="T2 password for DLR user",
            value=f"t2-{project.slug}-password-{''.join(random.choice(string.ascii_letters) for x in range(5))}",
            value_type="char",
        )


def reverse_func(apps, schema_editor):
    pass


class Migration(migrations.Migration):
    dependencies = [
        ("notifications", "0004_alter_djangoprojectbasenotification_options"),
        ("notifications", "0004_alter_djangoprojectbasenotification_options_and_more"),
    ]

    operations = [
        migrations.RunPython(forwards_func, reverse_func),
    ]
