# Generated by Django 4.2.4 on 2023-09-06 08:48

from django.db import migrations, models
import django.db.models.deletion
import django_project_base.notifications.models
import uuid


class Migration(migrations.Migration):
    dependencies = [
        ("notifications", "0003_alter_djangoprojectbasemessage_options_and_more"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="djangoprojectbasenotification",
            options={"verbose_name": "Notification"},
        ),
        migrations.CreateModel(
            name="DeliveryReport",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        primary_key=True,
                        serialize=False,
                        verbose_name="Id",
                    ),
                ),
                ("user_id", models.CharField(db_index=True, max_length=1024)),
                ("channel", models.CharField(max_length=1024)),
                ("provider", models.CharField(db_index=True, max_length=1024)),
                ("payload", models.JSONField(null=True)),
                (
                    "status",
                    models.IntegerField(
                        choices=[
                            (
                                django_project_base.notifications.models.DeliveryReport.Status["DELIVERED"],
                                "Delivered",
                            ),
                            (
                                django_project_base.notifications.models.DeliveryReport.Status["NOT_DELIVERED"],
                                "Not Delivered",
                            ),
                            (
                                django_project_base.notifications.models.DeliveryReport.Status["PENDING_DELIVERY"],
                                "Pending delivery",
                            ),
                        ],
                        db_index=True,
                        default=django_project_base.notifications.models.DeliveryReport.Status["PENDING_DELIVERY"],
                    ),
                ),
                (
                    "notification",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="notifications.djangoprojectbasenotification",
                    ),
                ),
            ],
        ),
    ]
