## bitfy - Your Terminal Assistant (Revised Summary)

This document outlines the functionality of the `bitfy` command-line tool, designed to be used directly within your terminal (PowerShell, Bash, Zsh, etc.) to leverage AI capabilities. All commands begin with `bitfy`.

**Key Functionality:**

Here's a simplified breakdown of the commands, based on your provided input:

*   **`bitfy --ask 'question'`:**  Asks the AI a question.
*   **`bitfy --explain -e 'filepath' 'prompt'`:** Explains the content of a file.  The 'filepath' specifies the file, and the 'prompt' guides the explanation (e.g., "Explain this code").
*   **`bitfy --write -w 'directory' 'filename' 'prompt'`:** Writes content generated by the AI to a new file.  Specify the 'directory', 'filename', and the 'prompt' to guide the content generation.
*   **`bitfy --shell -s 'command'`:** Translates a natural language 'command' into a shell command.  For example, you could ask it to "list all files".

**Important Considerations:**

*   Commands start with `bitfy`.
*   You can use this tool anywhere within your terminal environment (PowerShell, Bash, Zsh).
*   Prompts containing spaces should be enclosed in single quotes (`'`).


### Examples

1. **Ask a Question:**
   ```bash
   bitfy --ask 'What is the capital of France?'
   ```

2. **Explain File Content:**
   ```bash
   bitfy --explain '/path/to/file.py' 'Explain this code'
   ```

3. **Write to a File:**
   ```bash
   bitfy --write '/my/directory' 'output.txt' 'Generate content about machine learning'
   ```

4. **Convert Natural Language to Shell Command:**
   ```bash
   bitfy --shell 'list all files in the current directory'
   ```
