/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import java.util.Arrays;
import java.util.Collection;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.ComplexDoubleVector;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.FunctionException;
import org.jpmml.evaluator.TypeInfo;
import org.jpmml.evaluator.TypeInfos;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.functions.BinaryFunction;

public class PercentileFunction
extends BinaryFunction {
    public PercentileFunction() {
        this(PercentileFunction.class.getName());
    }

    public PercentileFunction(String name) {
        super(name, Arrays.asList("values", "percentile"));
    }

    public Double evaluate(Collection<?> values, int percentile) {
        if (percentile < 1 || percentile > 100) {
            throw new FunctionException((Function)this, "Invalid \"percentile\" value " + percentile + ". Must be greater than 0 and equal or less than 100");
        }
        ComplexDoubleVector doubleValues = new ComplexDoubleVector(values.size());
        for (Object value : values) {
            Number number = (Number)TypeUtil.parseOrCast((DataType)DataType.DOUBLE, value);
            doubleValues.add((Number)number.doubleValue());
        }
        return doubleValues.doublePercentile(percentile);
    }

    public FieldValue evaluate(FieldValue first, FieldValue second) {
        Double result = this.evaluate(first.asCollection(), second.asInteger());
        return FieldValueUtil.create((TypeInfo)TypeInfos.CONTINUOUS_DOUBLE, (Object)result);
    }
}

