/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.visitors;

import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Lag;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Matrix;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.TableLocator;
import org.dmg.pmml.TextIndex;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.baseline.BaselineModel;
import org.dmg.pmml.bayesian_network.BayesianNetworkModel;
import org.dmg.pmml.clustering.CenterFields;
import org.dmg.pmml.clustering.ClusteringModel;
import org.dmg.pmml.gaussian_process.GaussianProcessModel;
import org.dmg.pmml.general_regression.Categories;
import org.dmg.pmml.general_regression.Predictor;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.regression.Regression;
import org.dmg.pmml.sequence.SequenceModel;
import org.dmg.pmml.support_vector_machine.SupportVectorMachineModel;
import org.dmg.pmml.text.TextModel;
import org.dmg.pmml.time_series.TimeSeriesModel;
import org.dmg.pmml.tree.DecisionTree;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.UnsupportedElementException;
import org.jpmml.evaluator.UnsupportedMarkupException;
import org.jpmml.evaluator.visitors.MarkupInspector;

public class UnsupportedMarkupInspector
extends MarkupInspector<UnsupportedMarkupException> {
    public VisitorAction visit(Aggregate aggregate) {
        Aggregate.Function function = aggregate.getFunction();
        switch (function) {
            case MULTISET: {
                this.report(new UnsupportedAttributeException((PMMLObject)aggregate, (Enum<?>)function));
                break;
            }
        }
        return super.visit(aggregate);
    }

    public VisitorAction visit(Apply apply) {
        String function;
        switch (function = apply.getFunction()) {
            case "erf": 
            case "normalCDF": 
            case "normalIDF": 
            case "normalPDF": 
            case "stdNormalCDF": 
            case "stdNormalIDF": 
            case "stdNormalPDF": {
                this.report(new UnsupportedAttributeException((PMMLObject)apply, PMMLAttributes.APPLY_FUNCTION, function));
                break;
            }
        }
        return super.visit(apply);
    }

    public VisitorAction visit(BaselineModel baselineModel) {
        this.report(new UnsupportedElementException((PMMLObject)baselineModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(BayesianNetworkModel bayesianNetworkModel) {
        this.report(new UnsupportedElementException((PMMLObject)bayesianNetworkModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(CenterFields centerFields) {
        this.report(new UnsupportedElementException((PMMLObject)centerFields));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(ClusteringModel clusteringModel) {
        ClusteringModel.ModelClass modelClass = clusteringModel.getModelClass();
        switch (modelClass) {
            case DISTRIBUTION_BASED: {
                this.report(new UnsupportedAttributeException((PMMLObject)clusteringModel, (Enum<?>)modelClass));
                break;
            }
        }
        return super.visit(clusteringModel);
    }

    public VisitorAction visit(DecisionTree decisionTree) {
        this.report(new UnsupportedElementException((PMMLObject)decisionTree));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(GaussianProcessModel gaussianProcessModel) {
        this.report(new UnsupportedElementException((PMMLObject)gaussianProcessModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(Lag lag) {
        this.report(new UnsupportedElementException((PMMLObject)lag));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(NormDiscrete normDiscrete) {
        NormDiscrete.Method method = normDiscrete.getMethod();
        switch (method) {
            case THERMOMETER: {
                this.report(new UnsupportedAttributeException((PMMLObject)normDiscrete, (Enum<?>)method));
                break;
            }
        }
        return super.visit(normDiscrete);
    }

    public VisitorAction visit(OutputField outputField) {
        ResultFeature resultFeature = outputField.getResultFeature();
        switch (resultFeature) {
            case STANDARD_ERROR: {
                this.report(new UnsupportedAttributeException((PMMLObject)outputField, (Enum<?>)resultFeature));
                break;
            }
        }
        return super.visit(outputField);
    }

    public VisitorAction visit(Predictor predictor) {
        Categories categories;
        Matrix matrix = predictor.getMatrix();
        if (matrix != null && (categories = predictor.getCategories()) == null) {
            this.report(new UnsupportedElementException((PMMLObject)predictor));
        }
        return super.visit(predictor);
    }

    public VisitorAction visit(Regression regression) {
        this.report(new UnsupportedElementException((PMMLObject)regression));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(Segmentation segmentation) {
        LocalTransformations localTransformations = segmentation.getLocalTransformations();
        if (localTransformations != null) {
            this.report(new UnsupportedElementException((PMMLObject)localTransformations));
        }
        return super.visit(segmentation);
    }

    public VisitorAction visit(SequenceModel sequenceModel) {
        this.report(new UnsupportedElementException((PMMLObject)sequenceModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(SupportVectorMachineModel supportVectorMachineModel) {
        boolean maxWins = supportVectorMachineModel.isMaxWins();
        if (maxWins) {
            this.report(new UnsupportedAttributeException((PMMLObject)supportVectorMachineModel, org.dmg.pmml.support_vector_machine.PMMLAttributes.SUPPORTVECTORMACHINEMODEL_MAXWINS, true));
        }
        SupportVectorMachineModel.Representation representation = supportVectorMachineModel.getRepresentation();
        switch (representation) {
            case COEFFICIENTS: {
                this.report(new UnsupportedAttributeException((PMMLObject)supportVectorMachineModel, (Enum<?>)representation));
                break;
            }
        }
        return super.visit(supportVectorMachineModel);
    }

    public VisitorAction visit(TableLocator tableLocator) {
        this.report(new UnsupportedElementException((PMMLObject)tableLocator));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(TextIndex textIndex) {
        boolean tokenize = textIndex.isTokenize();
        if (!tokenize) {
            this.report(new UnsupportedAttributeException((PMMLObject)textIndex, PMMLAttributes.TEXTINDEX_TOKENIZE, false));
        }
        TextIndex.LocalTermWeights localTermWeights = textIndex.getLocalTermWeights();
        switch (localTermWeights) {
            case AUGMENTED_NORMALIZED_TERM_FREQUENCY: {
                this.report(new UnsupportedAttributeException((PMMLObject)textIndex, (Enum<?>)localTermWeights));
                break;
            }
        }
        return super.visit(textIndex);
    }

    public VisitorAction visit(TextModel textModel) {
        this.report(new UnsupportedElementException((PMMLObject)textModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(TimeSeriesModel timeSeriesModel) {
        this.report(new UnsupportedElementException((PMMLObject)timeSeriesModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(TreeModel treeModel) {
        TreeModel.MissingValueStrategy missingValueStrategy = treeModel.getMissingValueStrategy();
        switch (missingValueStrategy) {
            case AGGREGATE_NODES: 
            case WEIGHTED_CONFIDENCE: {
                this.report(new UnsupportedAttributeException((PMMLObject)treeModel, (Enum<?>)missingValueStrategy));
                break;
            }
        }
        return super.visit(treeModel);
    }
}

