/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.scorecard;

import java.util.List;
import java.util.Objects;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.HasReasonCodeRanking;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.scorecard.PartialScore;
import org.jpmml.evaluator.scorecard.ScorecardScore;
import org.jpmml.model.ToStringHelper;

public class ComplexScorecardScore<V extends Number>
extends ScorecardScore<V>
implements HasReasonCodeRanking {
    private ValueMap<String, V> reasonCodePoints = null;

    ComplexScorecardScore(Value<V> value, List<PartialScore> partialScores, ValueMap<String, V> reasonCodePoints) {
        super(value, partialScores);
        this.setReasonCodePoints(Objects.requireNonNull(reasonCodePoints));
    }

    @Override
    protected ToStringHelper toStringHelper() {
        ValueMap<String, V> reasonCodePoints = this.getReasonCodePoints();
        ToStringHelper helper = super.toStringHelper().add(Classification.Type.VOTE.entryKey(), reasonCodePoints.entrySet()).add("reasonCodeRanking", this.getReasonCodeRanking());
        return helper;
    }

    @Override
    public List<String> getReasonCodeRanking() {
        ValueMap<String, V> reasonCodePoints = this.getReasonCodePoints();
        return Classification.entryKeys(Classification.getWinnerList(Classification.Type.VOTE, reasonCodePoints.entrySet()));
    }

    public ValueMap<String, V> getReasonCodePoints() {
        return this.reasonCodePoints;
    }

    private void setReasonCodePoints(ValueMap<String, V> reasonCodePoints) {
        this.reasonCodePoints = reasonCodePoints;
    }
}

