/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.primitives.Longs;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import org.jpmml.evaluator.ComplexPeriod;

public class DaysSinceDate
extends ComplexPeriod<DaysSinceDate> {
    private long days = 0L;

    public DaysSinceDate(LocalDate epoch, LocalDate date) {
        this(epoch, ChronoUnit.DAYS.between(epoch, date));
    }

    public DaysSinceDate(LocalDate epoch, long days) {
        super(epoch);
        this.setDays(days);
    }

    @Override
    public long longValue() {
        return this.getDays();
    }

    @Override
    public int compareTo(DaysSinceDate that) {
        if (!this.getEpoch().equals(that.getEpoch())) {
            throw new ClassCastException();
        }
        return Long.compare(this.getDays(), that.getDays());
    }

    public int hashCode() {
        return 31 * this.getEpoch().hashCode() + Longs.hashCode((long)this.getDays());
    }

    public boolean equals(Object object) {
        if (object instanceof DaysSinceDate) {
            DaysSinceDate that = (DaysSinceDate)object;
            return this.getEpoch().equals(that.getEpoch()) && this.getDays() == that.getDays();
        }
        return false;
    }

    public long getDays() {
        return this.days;
    }

    private void setDays(long days) {
        this.days = days;
    }
}

