from py_wake import np
from py_wake.site._site import UniformWeibullSite
from py_wake.wind_turbines import OneTypeWindTurbines
from py_wake.wind_turbines.power_ct_functions import PowerCtTabular
from py_wake.wind_turbines._wind_turbines import WindTurbine

wt_x = [361469.3, 361202.9, 360936.4, 360670, 360403.6, 360137.1, 359870.7,
        361202.8, 360936.4, 360670, 360403.6, 360137.1, 359870.7, 359604.3,
        359337.9, 360936.4, 360670, 360403.6, 360137.1, 359870.7, 359604.3,
        359337.9, 359071.4, 360670, 360403.6, 360137.1, 359870.7, 359337.9,
        359071.4, 358805, 360390.2, 360137.1, 359870.7, 359604.3, 359071.4,
        358805, 359870.7, 359604.3, 359337.9, 359071.4, 358805, 359604.3,
        359337.9, 359071.4, 358805, 359337.9, 359071.4, 358805]

wt_y = [6154542.7, 6154244.4, 6153946, 6153647.7, 6153349.3, 6153050.9, 6152752.6,
        6154694.8, 6154396.4, 6154098.1, 6153799.1, 6153501.3, 6153203, 6152904.6,
        6152606.3, 6154846.8, 6154548.5, 6154250.1, 6153951.8, 6153653.4, 6153355,
        6153056.7, 6152758.3, 6154998.9, 6154700.5, 6154402.2, 6154103, 6153507.1,
        6153208.7, 6152910.4, 6155136, 6154852.6, 6154554.2, 6154255.9, 6153659.1,
        6153360.8, 6155004.6, 6154706.3, 6154407.9, 6154109.5, 6153811.2, 6155156.1,
        6154858.3, 6154560, 6154261.6, 6155308.7, 6155010.4, 6154712]

power_curve = np.array([[3.0, 0.0],
                        [4.0, 65.0],
                        [5.0, 180.0],
                        [6.0, 352.0],
                        [7.0, 590.0],
                        [8.0, 906.0],
                        [9.0, 1308.0],
                        [10.0, 1767.0],
                        [11.0, 2085.0],
                        [12.0, 2234.0],
                        [13.0, 2283.0],
                        [14.0, 2296.0],
                        [15.0, 2299.0],
                        [16.0, 2300.0],
                        [17.0, 2300.0],
                        [18.0, 2300.0],
                        [19.0, 2300.0],
                        [20.0, 2300.0],
                        [21.0, 2300.0],
                        [22.0, 2300.0],
                        [23.0, 2300.0],
                        [24.0, 2300.0],
                        [25.0, 2300.0]])

ct_curve = np.array([[3.0, 0.0],
                     [4.0, 0.81],
                     [5.0, 0.84],
                     [6.0, 0.83],
                     [7.0, 0.85],
                     [8.0, 0.86],
                     [9.0, 0.87],
                     [10.0, 0.79],
                     [11.0, 0.67],
                     [12.0, 0.45],
                     [13.0, 0.34],
                     [14.0, 0.26],
                     [15.0, 0.21],
                     [16.0, 0.17],
                     [17.0, 0.14],
                     [18.0, 0.12],
                     [19.0, 0.1],
                     [20.0, 0.09],
                     [21.0, 0.07],
                     [22.0, 0.07],
                     [23.0, 0.06],
                     [24.0, 0.05],
                     [25.0, 0.05]])


class SWT2p3_93_65(WindTurbine):
    def __init__(self):
        WindTurbine.__init__(self, 'SWT2p3_93_65', diameter=92.6, hub_height=65,
                             powerCtFunction=PowerCtTabular(ws=power_curve[:, 0],
                                                            power=power_curve[:, 1],
                                                            power_unit='kW',
                                                            ct=ct_curve[:, 1]))


class LillgrundSite(UniformWeibullSite):
    def __init__(self, ti=0.1):
        f = [5.55, 5.13, 5.32, 7.63, 9.39, 7.14, 8.93, 12.22, 14.44, 13.66, 5.87, 4.72]
        a = [9.42] * 12
        k = [2.41] * 12
        UniformWeibullSite.__init__(self, f, a, k, ti)
        self.initial_position = np.array([wt_x, wt_y]).T


def main():
    if __name__ == '__main__':
        wt = SWT2p3_93_65()
        print('Diameter', wt.diameter())
        print('Hub height', wt.hub_height())
        ws = np.arange(3, 25)
        import matplotlib.pyplot as plt
        plt.plot(ws, wt.power(ws), '.-')
        plt.show()


main()
