from typing import Any, Optional

class _ServerNameIdentities(dict):
    def __init__(self, identities: Any) -> None: ...
    def add(self, identity: Any) -> None: ...
    def get(self, server_name: Any, default: Optional[Any] = ...): ...

class X509Credentials:
    def __new__(cls, *args: Any, **kwargs: Any): ...
    crl_list: Any = ...
    server_name_identities: Any = ...
    def __init__(self, cert: Optional[Any] = ..., key: Optional[Any] = ..., trusted: Any = ..., crl_list: Any = ..., identities: Any = ...) -> None: ...
    def __del__(self) -> None: ...
    def add_trusted(self, trusted: Any) -> None: ...
    @property
    def cert(self): ...
    @property
    def key(self): ...
    @property
    def identities(self): ...
    @property
    def trusted(self): ...
    max_verify_length: Any = ...
    max_verify_bits: Any = ...
    def check_certificate(self, cert: Any, cert_name: str = ...) -> None: ...
    def select_server_identity(self, session: Any): ...

class TLSContextServerOptions:
    certificate_request: Any = ...
    def __init__(self, certificate_request: Any = ...) -> None: ...

class TLSContext:
    credentials: Any = ...
    server_options: Any = ...
    def __init__(self, credentials: Any, session_parameters: Optional[Any] = ..., server_options: Optional[Any] = ...) -> None: ...
    @property
    def session_parameters(self): ...
    @session_parameters.setter
    def session_parameters(self, value: Any) -> None: ...

class Session:
    session_type: Optional[int] = ...
    def __new__(cls, *args: Any, **kwargs: Any): ...
    socket: Any = ...
    credentials: Any = ...
    def __init__(self, socket: Any, context: Any) -> None: ...
    def __del__(self) -> None: ...
    def __getattr__(self, name: Any): ...
    @property
    def protocol(self): ...
    @property
    def kx_algorithm(self): ...
    @property
    def cipher(self): ...
    @property
    def mac_algorithm(self): ...
    @property
    def compression(self): ...
    @property
    def peer_certificate(self): ...
    @property
    def interrupted_while_writing(self): ...
    @property
    def interrupted_while_reading(self): ...
    def handshake(self) -> None: ...
    def send(self, data: Any): ...
    def sendall(self, data: Any) -> None: ...
    def recv(self, limit: Any): ...
    def send_alert(self, exception: Any) -> None: ...
    def bye(self, how: Any = ...) -> None: ...
    def shutdown(self, how: Any = ...) -> None: ...
    def close(self) -> None: ...
    def verify_peer(self) -> None: ...

class ClientSession(Session):
    session_type: Any = ...
    server_name: Any = ...
    def __init__(self, socket: Any, context: Any, server_name: Optional[Any] = ...) -> None: ...

class ServerSession(Session):
    session_type: Any = ...
    def __init__(self, socket: Any, context: Any) -> None: ...
    @property
    def server_name(self): ...

class ServerSessionFactory:
    socket: Any = ...
    context: Any = ...
    session_class: Any = ...
    def __init__(self, socket: Any, context: Any, session_class: Any = ...) -> None: ...
    def __getattr__(self, name: Any): ...
    def bind(self, address: Any) -> None: ...
    def listen(self, backlog: Any) -> None: ...
    def accept(self): ...
    def shutdown(self, how: Any = ...) -> None: ...
    def close(self) -> None: ...
