import * as cfnspec from '../../cfnspec/lib';
import { PropertyChange, ResourceChange } from '../diff/types';
import { DiffableCollection } from '../diffable';
import { ManagedPolicyAttachment, ManagedPolicyJson } from './managed-policy';
import { Statement, StatementJson } from './statement';
export interface IamChangesProps {
    propertyChanges: PropertyChange[];
    resourceChanges: ResourceChange[];
}
/**
 * Changes to IAM statements
 */
export declare class IamChanges {
    static IamPropertyScrutinies: cfnspec.schema.PropertyScrutinyType[];
    static IamResourceScrutinies: cfnspec.schema.ResourceScrutinyType[];
    readonly statements: DiffableCollection<Statement>;
    readonly managedPolicies: DiffableCollection<ManagedPolicyAttachment>;
    constructor(props: IamChangesProps);
    get hasChanges(): boolean;
    /**
     * Return whether the changes include broadened permissions
     *
     * Permissions are broadened if positive statements are added or
     * negative statements are removed, or if managed policies are added.
     */
    get permissionsBroadened(): boolean;
    /**
     * Return a summary table of changes
     */
    summarizeStatements(): string[][];
    summarizeManagedPolicies(): string[][];
    /**
     * Return a machine-readable version of the changes.
     * This is only used in tests.
     *
     * @internal
     */
    _toJson(): IamChangesJson;
    private readPropertyChange;
    private readResourceChange;
    /**
     * Parse a list of policies on an identity
     */
    private readIdentityPolicies;
    /**
     * Parse an IAM::Policy resource
     */
    private readIdentityPolicyResource;
    private readResourceStatements;
    /**
     * Parse an AWS::*::{Bucket,Topic,Queue}policy
     */
    private readResourcePolicyResource;
    private readManagedPolicies;
    private readLambdaStatements;
}
export interface IamChangesJson {
    statementAdditions?: StatementJson[];
    statementRemovals?: StatementJson[];
    managedPolicyAdditions?: ManagedPolicyJson[];
    managedPolicyRemovals?: ManagedPolicyJson[];
}
