import { Stack } from '@aws-cdk/core';
/**
 * (experimental) Suite of assertions that can be run on a CDK stack.
 *
 * Typically used, as part of unit tests, to validate that the rendered
 * CloudFormation template has expected resources and properties.
 *
 * @experimental
 */
export declare class Template {
    /**
     * (experimental) Base your assertions on the CloudFormation template synthesized by a CDK `Stack`.
     *
     * @param stack the CDK Stack to run assertions on.
     * @experimental
     */
    static fromStack(stack: Stack): Template;
    /**
     * (experimental) Base your assertions from an existing CloudFormation template formatted as an in-memory JSON object.
     *
     * @param template the CloudFormation template formatted as a nested set of records.
     * @experimental
     */
    static fromJSON(template: {
        [key: string]: any;
    }): Template;
    /**
     * (experimental) Base your assertions from an existing CloudFormation template formatted as a JSON string.
     *
     * @param template the CloudFormation template in.
     * @experimental
     */
    static fromString(template: string): Template;
    private readonly template;
    private readonly inspector;
    private constructor();
    /**
     * (experimental) The CloudFormation template deserialized into an object.
     *
     * @experimental
     */
    toJSON(): {
        [key: string]: any;
    };
    /**
     * (experimental) Assert that the given number of resources of the given type exist in the template.
     *
     * @param type the resource type;
     * @param count number of expected instances.
     * @experimental
     */
    resourceCountIs(type: string, count: number): void;
    /**
     * (experimental) Assert that a resource of the given type and properties exists in the CloudFormation template.
     *
     * By default, performs partial matching on the `Properties` key of the resource, via the
     * `Match.objectLike()`. To configure different behavour, use other matchers in the `Match` class.
     *
     * @param type the resource type;
     * @param props the 'Properties' section of the resource as should be expected in the template.
     * @experimental
     */
    hasResourceProperties(type: string, props: any): void;
    /**
     * (experimental) Assert that a resource of the given type and given definition exists in the CloudFormation template.
     *
     * By default, performs partial matching on the resource, via the `Match.objectLike()`.
     * To configure different behavour, use other matchers in the `Match` class.
     *
     * @param type the resource type;
     * @param props the entire defintion of the resource as should be expected in the template.
     * @experimental
     */
    hasResource(type: string, props: any): void;
    /**
     * (experimental) Get the set of matching resources of a given type and properties in the CloudFormation template.
     *
     * @param type the type to match in the CloudFormation template.
     * @param props by default, matches all resources with the given type.
     * @experimental
     */
    findResources(type: string, props?: any): {
        [key: string]: any;
    }[];
    /**
     * (experimental) Assert that an Output with the given properties exists in the CloudFormation template.
     *
     * By default, performs partial matching on the resource, via the `Match.objectLike()`.
     * To configure different behavour, use other matchers in the `Match` class.
     *
     * @param logicalId the name of the output.
     * @param props the output as should be expected in the template.
     * @experimental
     */
    hasOutput(logicalId: string, props: any): void;
    /**
     * (experimental) Get the set of matching Outputs that match the given properties in the CloudFormation template.
     *
     * @param logicalId the name of the output.
     * @param props by default, matches all Outputs in the template.
     * @experimental
     */
    findOutputs(logicalId: string, props?: any): {
        [key: string]: any;
    }[];
    /**
     * (experimental) Assert that a Mapping with the given properties exists in the CloudFormation template.
     *
     * By default, performs partial matching on the resource, via the `Match.objectLike()`.
     * To configure different behavour, use other matchers in the `Match` class.
     *
     * @param logicalId the name of the mapping.
     * @param props the output as should be expected in the template.
     * @experimental
     */
    hasMapping(logicalId: string, props: any): void;
    /**
     * (experimental) Get the set of matching Mappings that match the given properties in the CloudFormation template.
     *
     * @param logicalId the name of the mapping.
     * @param props by default, matches all Mappings in the template.
     * @experimental
     */
    findMappings(logicalId: string, props?: any): {
        [key: string]: any;
    }[];
    /**
     * (experimental) Assert that the CloudFormation template matches the given value.
     *
     * @param expected the expected CloudFormation template as key-value pairs.
     * @experimental
     */
    templateMatches(expected: {
        [key: string]: any;
    }): void;
}
