"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.filterLogicalId = exports.formatFailure = exports.matchSection = void 0;
const match_1 = require("../match");
const matcher_1 = require("../matcher");
function matchSection(section, props) {
    const matcher = matcher_1.Matcher.isMatcher(props) ? props : match_1.Match.objectLike(props);
    let closestResult = undefined;
    let matching = [];
    let count = 0;
    eachEntryInSection(section, (entry) => {
        const result = matcher.test(entry);
        if (!result.hasFailed()) {
            matching.push(entry);
        }
        else {
            count++;
            if (closestResult === undefined || closestResult.failCount > result.failCount) {
                closestResult = result;
            }
        }
    });
    if (matching.length > 0) {
        return { match: true, matches: matching };
    }
    else {
        return { match: false, closestResult, analyzedCount: count };
    }
}
exports.matchSection = matchSection;
function eachEntryInSection(section, cb) {
    for (const logicalId of Object.keys(section !== null && section !== void 0 ? section : {})) {
        const resource = section[logicalId];
        cb(resource);
    }
}
function formatFailure(closestResult) {
    return [
        'The closest result is:',
        leftPad(JSON.stringify(closestResult.target, undefined, 2)),
        'with the following mismatches:',
        ...closestResult.toHumanStrings().map(s => `\t${s}`),
    ].join('\n');
}
exports.formatFailure = formatFailure;
function leftPad(x, indent = 2) {
    const pad = ' '.repeat(indent);
    return pad + x.split('\n').join(`\n${pad}`);
}
function filterLogicalId(section, logicalId) {
    // default signal for all logicalIds is '*'
    if (logicalId === '*')
        return section;
    return Object.entries(section !== null && section !== void 0 ? section : {})
        .filter(([k, _]) => k === logicalId)
        .reduce((agg, [k, v]) => { return { ...agg, [k]: v }; }, {});
}
exports.filterLogicalId = filterLogicalId;
//# sourceMappingURL=data:application/json;base64,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