"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasOutput = exports.findOutputs = void 0;
const section_1 = require("./section");
function findOutputs(inspector, logicalId, props = {}) {
    const section = inspector.value.Outputs;
    const result = section_1.matchSection(section_1.filterLogicalId(section, logicalId), props);
    if (!result.match) {
        return [];
    }
    return result.matches;
}
exports.findOutputs = findOutputs;
function hasOutput(inspector, logicalId, props) {
    const section = inspector.value.Outputs;
    const result = section_1.matchSection(section_1.filterLogicalId(section, logicalId), props);
    if (result.match) {
        return;
    }
    if (result.closestResult === undefined) {
        return `No outputs named ${logicalId} found in the template.`;
    }
    return [
        `Template has ${result.analyzedCount} outputs named ${logicalId}, but none match as expected.`,
        section_1.formatFailure(result.closestResult),
    ].join('\n');
}
exports.hasOutput = hasOutput;
//# sourceMappingURL=data:application/json;base64,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