"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasMapping = exports.findMappings = void 0;
const section_1 = require("./section");
function findMappings(inspector, logicalId, props = {}) {
    const section = inspector.value.Mappings;
    const result = section_1.matchSection(section_1.filterLogicalId(section, logicalId), props);
    if (!result.match) {
        return [];
    }
    return result.matches;
}
exports.findMappings = findMappings;
function hasMapping(inspector, logicalId, props) {
    const section = inspector.value.Mappings;
    const result = section_1.matchSection(section_1.filterLogicalId(section, logicalId), props);
    if (result.match) {
        return;
    }
    if (result.closestResult === undefined) {
        return 'No mappings found in the template';
    }
    return [
        `Template has ${result.analyzedCount} mappings, but none match as expected.`,
        section_1.formatFailure(result.closestResult),
    ].join('\n');
}
exports.hasMapping = hasMapping;
//# sourceMappingURL=data:application/json;base64,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