/**
 * (experimental) Represents a matcher that can perform special data matching capabilities between a given pattern and a target.
 *
 * @experimental
 */
export declare abstract class Matcher {
    /**
     * (experimental) Check whether the provided object is a subtype of the `IMatcher`.
     *
     * @experimental
     */
    static isMatcher(x: any): x is Matcher;
    /**
     * (experimental) A name for the matcher.
     *
     * This is collected as part of the result and may be presented to the user.
     *
     * @experimental
     */
    abstract readonly name: string;
    /**
     * (experimental) Test whether a target matches the provided pattern.
     *
     * @param actual the target to match.
     * @returns the list of match failures. An empty array denotes a successful match.
     * @experimental
     */
    abstract test(actual: any): MatchResult;
}
/**
 * (experimental) The result of `Match.test()`.
 *
 * @experimental
 */
export declare class MatchResult {
    /**
     * (experimental) The target for which this result was generated.
     *
     * @experimental
     */
    readonly target: any;
    private readonly failures;
    /**
     * @experimental
     */
    constructor(target: any);
    /**
     * (experimental) Push a new failure into this result at a specific path.
     *
     * If the failure occurred at root of the match tree, set the path to an empty list.
     * If it occurs in the 5th index of an array nested within the 'foo' key of an object,
     * set the path as `['/foo', '[5]']`.
     *
     * @param path the path at which the failure occurred.
     * @param message the failure.
     * @experimental
     */
    push(matcher: Matcher, path: string[], message: string): this;
    /**
     * (experimental) Does the result contain any failures.
     *
     * If not, the result is a success
     *
     * @experimental
     */
    hasFailed(): boolean;
    /**
     * (experimental) The number of failures.
     *
     * @experimental
     */
    get failCount(): number;
    /**
     * (experimental) Compose the results of a previous match as a subtree.
     *
     * @param id the id of the parent tree.
     * @experimental
     */
    compose(id: string, inner: MatchResult): this;
    /**
     * (experimental) Get the list of failures as human readable strings.
     *
     * @experimental
     */
    toHumanStrings(): string[];
}
