import { Matcher } from './matcher';
/**
 * (experimental) Partial and special matching during template assertions.
 *
 * @experimental
 */
export declare abstract class Match {
    /**
     * (experimental) Use this matcher in the place of a field's value, if the field must not be present.
     *
     * @experimental
     */
    static absentProperty(): string;
    /**
     * (experimental) Matches the specified pattern with the array found in the same relative path of the target.
     *
     * The set of elements (or matchers) must be in the same order as would be found.
     *
     * @param pattern the pattern to match.
     * @experimental
     */
    static arrayWith(pattern: any[]): Matcher;
    /**
     * (experimental) Matches the specified pattern with the array found in the same relative path of the target.
     *
     * The set of elements (or matchers) must match exactly and in order.
     *
     * @param pattern the pattern to match.
     * @experimental
     */
    static arrayEquals(pattern: any[]): Matcher;
    /**
     * (experimental) Deep exact matching of the specified pattern to the target.
     *
     * @param pattern the pattern to match.
     * @experimental
     */
    static exact(pattern: any): Matcher;
    /**
     * (experimental) Matches the specified pattern to an object found in the same relative path of the target.
     *
     * The keys and their values (or matchers) must be present in the target but the target can be a superset.
     *
     * @param pattern the pattern to match.
     * @experimental
     */
    static objectLike(pattern: {
        [key: string]: any;
    }): Matcher;
    /**
     * (experimental) Matches the specified pattern to an object found in the same relative path of the target.
     *
     * The keys and their values (or matchers) must match exactly with the target.
     *
     * @param pattern the pattern to match.
     * @experimental
     */
    static objectEquals(pattern: {
        [key: string]: any;
    }): Matcher;
    /**
     * (experimental) Matches any target which does NOT follow the specified pattern.
     *
     * @param pattern the pattern to NOT match.
     * @experimental
     */
    static not(pattern: any): Matcher;
}
