import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VaultProviderConfig {
    /**
    * If true, adds the value of the `address` argument to the Terraform process environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#add_address_to_env VaultProvider#add_address_to_env}
    */
    readonly addAddressToEnv?: string;
    /**
    * URL of the root of the target Vault server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#address VaultProvider#address}
    */
    readonly address: string;
    /**
    * Path to directory containing CA certificate files to validate the server's certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#ca_cert_dir VaultProvider#ca_cert_dir}
    */
    readonly caCertDir?: string;
    /**
    * Path to a CA certificate file to validate the server's certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#ca_cert_file VaultProvider#ca_cert_file}
    */
    readonly caCertFile?: string;
    /**
    * Maximum TTL for secret leases requested by this provider.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#max_lease_ttl_seconds VaultProvider#max_lease_ttl_seconds}
    */
    readonly maxLeaseTtlSeconds?: number;
    /**
    * Maximum number of retries when a 5xx error code is encountered.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#max_retries VaultProvider#max_retries}
    */
    readonly maxRetries?: number;
    /**
    * Maximum number of retries for Client Controlled Consistency related operations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#max_retries_ccc VaultProvider#max_retries_ccc}
    */
    readonly maxRetriesCcc?: number;
    /**
    * The namespace to use. Available only for Vault Enterprise.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#namespace VaultProvider#namespace}
    */
    readonly namespace?: string;
    /**
    * Set this to true to prevent the creation of ephemeral child token used by this provider.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#skip_child_token VaultProvider#skip_child_token}
    */
    readonly skipChildToken?: boolean | cdktf.IResolvable;
    /**
    * Set this to true only if the target Vault server is an insecure development instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#skip_tls_verify VaultProvider#skip_tls_verify}
    */
    readonly skipTlsVerify?: boolean | cdktf.IResolvable;
    /**
    * Name to use as the SNI host when connecting via TLS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#tls_server_name VaultProvider#tls_server_name}
    */
    readonly tlsServerName?: string;
    /**
    * Token to use to authenticate to Vault.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#token VaultProvider#token}
    */
    readonly token?: string;
    /**
    * Token name to use for creating the Vault child token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#token_name VaultProvider#token_name}
    */
    readonly tokenName?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#alias VaultProvider#alias}
    */
    readonly alias?: string;
    /**
    * auth_login block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#auth_login VaultProvider#auth_login}
    */
    readonly authLogin?: VaultProviderAuthLogin[] | cdktf.IResolvable;
    /**
    * client_auth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#client_auth VaultProvider#client_auth}
    */
    readonly clientAuth?: VaultProviderClientAuth[] | cdktf.IResolvable;
    /**
    * headers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#headers VaultProvider#headers}
    */
    readonly headers?: VaultProviderHeaders[] | cdktf.IResolvable;
}
export interface VaultProviderAuthLogin {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#method VaultProvider#method}
    */
    readonly method?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#namespace VaultProvider#namespace}
    */
    readonly namespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#parameters VaultProvider#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#path VaultProvider#path}
    */
    readonly path: string;
}
export declare function vaultProviderAuthLoginToTerraform(struct?: VaultProviderAuthLogin | cdktf.IResolvable): any;
export interface VaultProviderClientAuth {
    /**
    * Path to a file containing the client certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#cert_file VaultProvider#cert_file}
    */
    readonly certFile?: string;
    /**
    * Path to a file containing the private key that the certificate was issued for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#key_file VaultProvider#key_file}
    */
    readonly keyFile?: string;
}
export declare function vaultProviderClientAuthToTerraform(struct?: VaultProviderClientAuth | cdktf.IResolvable): any;
export interface VaultProviderHeaders {
    /**
    * The header name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#name VaultProvider#name}
    */
    readonly name: string;
    /**
    * The header value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault#value VaultProvider#value}
    */
    readonly value: string;
}
export declare function vaultProviderHeadersToTerraform(struct?: VaultProviderHeaders | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault vault}
*/
export declare class VaultProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "vault";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault vault} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VaultProviderConfig
    */
    constructor(scope: Construct, id: string, config: VaultProviderConfig);
    private _addAddressToEnv?;
    get addAddressToEnv(): string | undefined;
    set addAddressToEnv(value: string | undefined);
    resetAddAddressToEnv(): void;
    get addAddressToEnvInput(): string | undefined;
    private _address?;
    get address(): string | undefined;
    set address(value: string | undefined);
    get addressInput(): string | undefined;
    private _caCertDir?;
    get caCertDir(): string | undefined;
    set caCertDir(value: string | undefined);
    resetCaCertDir(): void;
    get caCertDirInput(): string | undefined;
    private _caCertFile?;
    get caCertFile(): string | undefined;
    set caCertFile(value: string | undefined);
    resetCaCertFile(): void;
    get caCertFileInput(): string | undefined;
    private _maxLeaseTtlSeconds?;
    get maxLeaseTtlSeconds(): number | undefined;
    set maxLeaseTtlSeconds(value: number | undefined);
    resetMaxLeaseTtlSeconds(): void;
    get maxLeaseTtlSecondsInput(): number | undefined;
    private _maxRetries?;
    get maxRetries(): number | undefined;
    set maxRetries(value: number | undefined);
    resetMaxRetries(): void;
    get maxRetriesInput(): number | undefined;
    private _maxRetriesCcc?;
    get maxRetriesCcc(): number | undefined;
    set maxRetriesCcc(value: number | undefined);
    resetMaxRetriesCcc(): void;
    get maxRetriesCccInput(): number | undefined;
    private _namespace?;
    get namespace(): string | undefined;
    set namespace(value: string | undefined);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _skipChildToken?;
    get skipChildToken(): boolean | cdktf.IResolvable | undefined;
    set skipChildToken(value: boolean | cdktf.IResolvable | undefined);
    resetSkipChildToken(): void;
    get skipChildTokenInput(): boolean | cdktf.IResolvable | undefined;
    private _skipTlsVerify?;
    get skipTlsVerify(): boolean | cdktf.IResolvable | undefined;
    set skipTlsVerify(value: boolean | cdktf.IResolvable | undefined);
    resetSkipTlsVerify(): void;
    get skipTlsVerifyInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsServerName?;
    get tlsServerName(): string | undefined;
    set tlsServerName(value: string | undefined);
    resetTlsServerName(): void;
    get tlsServerNameInput(): string | undefined;
    private _token?;
    get token(): string | undefined;
    set token(value: string | undefined);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _tokenName?;
    get tokenName(): string | undefined;
    set tokenName(value: string | undefined);
    resetTokenName(): void;
    get tokenNameInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _authLogin?;
    get authLogin(): VaultProviderAuthLogin[] | cdktf.IResolvable | undefined;
    set authLogin(value: VaultProviderAuthLogin[] | cdktf.IResolvable | undefined);
    resetAuthLogin(): void;
    get authLoginInput(): cdktf.IResolvable | VaultProviderAuthLogin[] | undefined;
    private _clientAuth?;
    get clientAuth(): VaultProviderClientAuth[] | cdktf.IResolvable | undefined;
    set clientAuth(value: VaultProviderClientAuth[] | cdktf.IResolvable | undefined);
    resetClientAuth(): void;
    get clientAuthInput(): cdktf.IResolvable | VaultProviderClientAuth[] | undefined;
    private _headers?;
    get headers(): VaultProviderHeaders[] | cdktf.IResolvable | undefined;
    set headers(value: VaultProviderHeaders[] | cdktf.IResolvable | undefined);
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | VaultProviderHeaders[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=vault-provider.d.ts.map