import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TransitSecretBackendKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * If set, enables taking backup of named key in the plaintext format. Once set, this cannot be disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transit_secret_backend_key#allow_plaintext_backup TransitSecretBackendKey#allow_plaintext_backup}
    */
    readonly allowPlaintextBackup?: boolean | cdktf.IResolvable;
    /**
    * Amount of time the key should live before being automatically rotated. A value of 0 disables automatic rotation for the key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transit_secret_backend_key#auto_rotate_interval TransitSecretBackendKey#auto_rotate_interval}
    */
    readonly autoRotateInterval?: number;
    /**
    * Amount of time the key should live before being automatically rotated. A value of 0 disables automatic rotation for the key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transit_secret_backend_key#auto_rotate_period TransitSecretBackendKey#auto_rotate_period}
    */
    readonly autoRotatePeriod?: number;
    /**
    * The Transit secret backend the resource belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transit_secret_backend_key#backend TransitSecretBackendKey#backend}
    */
    readonly backend: string;
    /**
    * Whether or not to support convergent encryption, where the same plaintext creates the same ciphertext. This requires derived to be set to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transit_secret_backend_key#convergent_encryption TransitSecretBackendKey#convergent_encryption}
    */
    readonly convergentEncryption?: boolean | cdktf.IResolvable;
    /**
    * Specifies if the key is allowed to be deleted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transit_secret_backend_key#deletion_allowed TransitSecretBackendKey#deletion_allowed}
    */
    readonly deletionAllowed?: boolean | cdktf.IResolvable;
    /**
    * Specifies if key derivation is to be used. If enabled, all encrypt/decrypt requests to this key must provide a context which is used for key derivation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transit_secret_backend_key#derived TransitSecretBackendKey#derived}
    */
    readonly derived?: boolean | cdktf.IResolvable;
    /**
    * Enables keys to be exportable. This allows for all the valid keys in the key ring to be exported. Once set, this cannot be disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transit_secret_backend_key#exportable TransitSecretBackendKey#exportable}
    */
    readonly exportable?: boolean | cdktf.IResolvable;
    /**
    * Minimum key version to use for decryption.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transit_secret_backend_key#min_decryption_version TransitSecretBackendKey#min_decryption_version}
    */
    readonly minDecryptionVersion?: number;
    /**
    * Minimum key version to use for encryption
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transit_secret_backend_key#min_encryption_version TransitSecretBackendKey#min_encryption_version}
    */
    readonly minEncryptionVersion?: number;
    /**
    * Name of the encryption key to create.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transit_secret_backend_key#name TransitSecretBackendKey#name}
    */
    readonly name: string;
    /**
    * Specifies the type of key to create. The currently-supported types are: aes128-gcm96, aes256-gcm96, chacha20-poly1305, ed25519, ecdsa-p256, ecdsa-p384, ecdsa-p521, rsa-2048, rsa-3072, rsa-4096
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transit_secret_backend_key#type TransitSecretBackendKey#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/transit_secret_backend_key vault_transit_secret_backend_key}
*/
export declare class TransitSecretBackendKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_transit_secret_backend_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/transit_secret_backend_key vault_transit_secret_backend_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TransitSecretBackendKeyConfig
    */
    constructor(scope: Construct, id: string, config: TransitSecretBackendKeyConfig);
    private _allowPlaintextBackup?;
    get allowPlaintextBackup(): boolean | cdktf.IResolvable;
    set allowPlaintextBackup(value: boolean | cdktf.IResolvable);
    resetAllowPlaintextBackup(): void;
    get allowPlaintextBackupInput(): boolean | cdktf.IResolvable | undefined;
    private _autoRotateInterval?;
    get autoRotateInterval(): number;
    set autoRotateInterval(value: number);
    resetAutoRotateInterval(): void;
    get autoRotateIntervalInput(): number | undefined;
    private _autoRotatePeriod?;
    get autoRotatePeriod(): number;
    set autoRotatePeriod(value: number);
    resetAutoRotatePeriod(): void;
    get autoRotatePeriodInput(): number | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _convergentEncryption?;
    get convergentEncryption(): boolean | cdktf.IResolvable;
    set convergentEncryption(value: boolean | cdktf.IResolvable);
    resetConvergentEncryption(): void;
    get convergentEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _deletionAllowed?;
    get deletionAllowed(): boolean | cdktf.IResolvable;
    set deletionAllowed(value: boolean | cdktf.IResolvable);
    resetDeletionAllowed(): void;
    get deletionAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _derived?;
    get derived(): boolean | cdktf.IResolvable;
    set derived(value: boolean | cdktf.IResolvable);
    resetDerived(): void;
    get derivedInput(): boolean | cdktf.IResolvable | undefined;
    private _exportable?;
    get exportable(): boolean | cdktf.IResolvable;
    set exportable(value: boolean | cdktf.IResolvable);
    resetExportable(): void;
    get exportableInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    keys(index: string, key: string): string | cdktf.IResolvable;
    get latestVersion(): number;
    get minAvailableVersion(): number;
    private _minDecryptionVersion?;
    get minDecryptionVersion(): number;
    set minDecryptionVersion(value: number);
    resetMinDecryptionVersion(): void;
    get minDecryptionVersionInput(): number | undefined;
    private _minEncryptionVersion?;
    get minEncryptionVersion(): number;
    set minEncryptionVersion(value: number);
    resetMinEncryptionVersion(): void;
    get minEncryptionVersionInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get supportsDecryption(): cdktf.IResolvable;
    get supportsDerivation(): cdktf.IResolvable;
    get supportsEncryption(): cdktf.IResolvable;
    get supportsSigning(): cdktf.IResolvable;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=transit-secret-backend-key.d.ts.map