import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TransformRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_role#name TransformRole#name}
    */
    readonly name: string;
    /**
    * The mount path for a back-end, for example, the path given in "$ vault auth enable -path=my-aws aws".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_role#path TransformRole#path}
    */
    readonly path: string;
    /**
    * A comma separated string or slice of transformations to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_role#transformations TransformRole#transformations}
    */
    readonly transformations?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/transform_role vault_transform_role}
*/
export declare class TransformRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_transform_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/transform_role vault_transform_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TransformRoleConfig
    */
    constructor(scope: Construct, id: string, config: TransformRoleConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _transformations?;
    get transformations(): string[];
    set transformations(value: string[]);
    resetTransformations(): void;
    get transformationsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=transform-role.d.ts.map