import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TransformAlphabetConfig extends cdktf.TerraformMetaArguments {
    /**
    * A string of characters that contains the alphabet set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_alphabet#alphabet TransformAlphabet#alphabet}
    */
    readonly alphabet?: string;
    /**
    * The name of the alphabet.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_alphabet#name TransformAlphabet#name}
    */
    readonly name: string;
    /**
    * The mount path for a back-end, for example, the path given in "$ vault auth enable -path=my-aws aws".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_alphabet#path TransformAlphabet#path}
    */
    readonly path: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/transform_alphabet vault_transform_alphabet}
*/
export declare class TransformAlphabet extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_transform_alphabet";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/transform_alphabet vault_transform_alphabet} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TransformAlphabetConfig
    */
    constructor(scope: Construct, id: string, config: TransformAlphabetConfig);
    private _alphabet?;
    get alphabet(): string;
    set alphabet(value: string);
    resetAlphabet(): void;
    get alphabetInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=transform-alphabet.d.ts.map