import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TokenAuthBackendRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Set of allowed entity aliases for this role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token_auth_backend_role#allowed_entity_aliases TokenAuthBackendRole#allowed_entity_aliases}
    */
    readonly allowedEntityAliases?: string[];
    /**
    * List of allowed policies for given role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token_auth_backend_role#allowed_policies TokenAuthBackendRole#allowed_policies}
    */
    readonly allowedPolicies?: string[];
    /**
    * Set of allowed policies with glob match for given role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token_auth_backend_role#allowed_policies_glob TokenAuthBackendRole#allowed_policies_glob}
    */
    readonly allowedPoliciesGlob?: string[];
    /**
    * List of disallowed policies for given role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token_auth_backend_role#disallowed_policies TokenAuthBackendRole#disallowed_policies}
    */
    readonly disallowedPolicies?: string[];
    /**
    * Set of disallowed policies with glob match for given role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token_auth_backend_role#disallowed_policies_glob TokenAuthBackendRole#disallowed_policies_glob}
    */
    readonly disallowedPoliciesGlob?: string[];
    /**
    * If true, tokens created against this policy will be orphan tokens.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token_auth_backend_role#orphan TokenAuthBackendRole#orphan}
    */
    readonly orphan?: boolean | cdktf.IResolvable;
    /**
    * Tokens created against this role will have the given suffix as part of their path in addition to the role name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token_auth_backend_role#path_suffix TokenAuthBackendRole#path_suffix}
    */
    readonly pathSuffix?: string;
    /**
    * Whether to disable the ability of the token to be renewed past its initial TTL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token_auth_backend_role#renewable TokenAuthBackendRole#renewable}
    */
    readonly renewable?: boolean | cdktf.IResolvable;
    /**
    * Name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token_auth_backend_role#role_name TokenAuthBackendRole#role_name}
    */
    readonly roleName: string;
    /**
    * Specifies the blocks of IP addresses which are allowed to use the generated token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token_auth_backend_role#token_bound_cidrs TokenAuthBackendRole#token_bound_cidrs}
    */
    readonly tokenBoundCidrs?: string[];
    /**
    * Generated Token's Explicit Maximum TTL in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token_auth_backend_role#token_explicit_max_ttl TokenAuthBackendRole#token_explicit_max_ttl}
    */
    readonly tokenExplicitMaxTtl?: number;
    /**
    * The maximum lifetime of the generated token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token_auth_backend_role#token_max_ttl TokenAuthBackendRole#token_max_ttl}
    */
    readonly tokenMaxTtl?: number;
    /**
    * If true, the 'default' policy will not automatically be added to generated tokens
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token_auth_backend_role#token_no_default_policy TokenAuthBackendRole#token_no_default_policy}
    */
    readonly tokenNoDefaultPolicy?: boolean | cdktf.IResolvable;
    /**
    * The maximum number of times a token may be used, a value of zero means unlimited
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token_auth_backend_role#token_num_uses TokenAuthBackendRole#token_num_uses}
    */
    readonly tokenNumUses?: number;
    /**
    * Generated Token's Period
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token_auth_backend_role#token_period TokenAuthBackendRole#token_period}
    */
    readonly tokenPeriod?: number;
    /**
    * Generated Token's Policies
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token_auth_backend_role#token_policies TokenAuthBackendRole#token_policies}
    */
    readonly tokenPolicies?: string[];
    /**
    * The initial ttl of the token to generate in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token_auth_backend_role#token_ttl TokenAuthBackendRole#token_ttl}
    */
    readonly tokenTtl?: number;
    /**
    * The type of token to generate, service or batch
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token_auth_backend_role#token_type TokenAuthBackendRole#token_type}
    */
    readonly tokenType?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/token_auth_backend_role vault_token_auth_backend_role}
*/
export declare class TokenAuthBackendRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_token_auth_backend_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/token_auth_backend_role vault_token_auth_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TokenAuthBackendRoleConfig
    */
    constructor(scope: Construct, id: string, config: TokenAuthBackendRoleConfig);
    private _allowedEntityAliases?;
    get allowedEntityAliases(): string[];
    set allowedEntityAliases(value: string[]);
    resetAllowedEntityAliases(): void;
    get allowedEntityAliasesInput(): string[] | undefined;
    private _allowedPolicies?;
    get allowedPolicies(): string[];
    set allowedPolicies(value: string[]);
    resetAllowedPolicies(): void;
    get allowedPoliciesInput(): string[] | undefined;
    private _allowedPoliciesGlob?;
    get allowedPoliciesGlob(): string[];
    set allowedPoliciesGlob(value: string[]);
    resetAllowedPoliciesGlob(): void;
    get allowedPoliciesGlobInput(): string[] | undefined;
    private _disallowedPolicies?;
    get disallowedPolicies(): string[];
    set disallowedPolicies(value: string[]);
    resetDisallowedPolicies(): void;
    get disallowedPoliciesInput(): string[] | undefined;
    private _disallowedPoliciesGlob?;
    get disallowedPoliciesGlob(): string[];
    set disallowedPoliciesGlob(value: string[]);
    resetDisallowedPoliciesGlob(): void;
    get disallowedPoliciesGlobInput(): string[] | undefined;
    get id(): string;
    private _orphan?;
    get orphan(): boolean | cdktf.IResolvable;
    set orphan(value: boolean | cdktf.IResolvable);
    resetOrphan(): void;
    get orphanInput(): boolean | cdktf.IResolvable | undefined;
    private _pathSuffix?;
    get pathSuffix(): string;
    set pathSuffix(value: string);
    resetPathSuffix(): void;
    get pathSuffixInput(): string | undefined;
    private _renewable?;
    get renewable(): boolean | cdktf.IResolvable;
    set renewable(value: boolean | cdktf.IResolvable);
    resetRenewable(): void;
    get renewableInput(): boolean | cdktf.IResolvable | undefined;
    private _roleName?;
    get roleName(): string;
    set roleName(value: string);
    get roleNameInput(): string | undefined;
    private _tokenBoundCidrs?;
    get tokenBoundCidrs(): string[];
    set tokenBoundCidrs(value: string[]);
    resetTokenBoundCidrs(): void;
    get tokenBoundCidrsInput(): string[] | undefined;
    private _tokenExplicitMaxTtl?;
    get tokenExplicitMaxTtl(): number;
    set tokenExplicitMaxTtl(value: number);
    resetTokenExplicitMaxTtl(): void;
    get tokenExplicitMaxTtlInput(): number | undefined;
    private _tokenMaxTtl?;
    get tokenMaxTtl(): number;
    set tokenMaxTtl(value: number);
    resetTokenMaxTtl(): void;
    get tokenMaxTtlInput(): number | undefined;
    private _tokenNoDefaultPolicy?;
    get tokenNoDefaultPolicy(): boolean | cdktf.IResolvable;
    set tokenNoDefaultPolicy(value: boolean | cdktf.IResolvable);
    resetTokenNoDefaultPolicy(): void;
    get tokenNoDefaultPolicyInput(): boolean | cdktf.IResolvable | undefined;
    private _tokenNumUses?;
    get tokenNumUses(): number;
    set tokenNumUses(value: number);
    resetTokenNumUses(): void;
    get tokenNumUsesInput(): number | undefined;
    private _tokenPeriod?;
    get tokenPeriod(): number;
    set tokenPeriod(value: number);
    resetTokenPeriod(): void;
    get tokenPeriodInput(): number | undefined;
    private _tokenPolicies?;
    get tokenPolicies(): string[];
    set tokenPolicies(value: string[]);
    resetTokenPolicies(): void;
    get tokenPoliciesInput(): string[] | undefined;
    private _tokenTtl?;
    get tokenTtl(): number;
    set tokenTtl(value: number);
    resetTokenTtl(): void;
    get tokenTtlInput(): number | undefined;
    private _tokenType?;
    get tokenType(): string;
    set tokenType(value: string);
    resetTokenType(): void;
    get tokenTypeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=token-auth-backend-role.d.ts.map