import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TerraformCloudSecretCredsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Terraform Cloud secret backend to generate tokens from
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_creds#backend TerraformCloudSecretCreds#backend}
    */
    readonly backend: string;
    /**
    * Name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_creds#role TerraformCloudSecretCreds#role}
    */
    readonly role: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_creds vault_terraform_cloud_secret_creds}
*/
export declare class TerraformCloudSecretCreds extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_terraform_cloud_secret_creds";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_creds vault_terraform_cloud_secret_creds} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TerraformCloudSecretCredsConfig
    */
    constructor(scope: Construct, id: string, config: TerraformCloudSecretCredsConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    get id(): string;
    get leaseId(): string;
    get organization(): string;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    get teamId(): string;
    get token(): string;
    get tokenId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=terraform-cloud-secret-creds.d.ts.map