import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SshSecretBackendRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#algorithm_signer SshSecretBackendRole#algorithm_signer}
    */
    readonly algorithmSigner?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#allow_bare_domains SshSecretBackendRole#allow_bare_domains}
    */
    readonly allowBareDomains?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#allow_host_certificates SshSecretBackendRole#allow_host_certificates}
    */
    readonly allowHostCertificates?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#allow_subdomains SshSecretBackendRole#allow_subdomains}
    */
    readonly allowSubdomains?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#allow_user_certificates SshSecretBackendRole#allow_user_certificates}
    */
    readonly allowUserCertificates?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#allow_user_key_ids SshSecretBackendRole#allow_user_key_ids}
    */
    readonly allowUserKeyIds?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#allowed_critical_options SshSecretBackendRole#allowed_critical_options}
    */
    readonly allowedCriticalOptions?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#allowed_domains SshSecretBackendRole#allowed_domains}
    */
    readonly allowedDomains?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#allowed_extensions SshSecretBackendRole#allowed_extensions}
    */
    readonly allowedExtensions?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#allowed_user_key_lengths SshSecretBackendRole#allowed_user_key_lengths}
    */
    readonly allowedUserKeyLengths?: {
        [key: string]: number;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#allowed_users SshSecretBackendRole#allowed_users}
    */
    readonly allowedUsers?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#allowed_users_template SshSecretBackendRole#allowed_users_template}
    */
    readonly allowedUsersTemplate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#backend SshSecretBackendRole#backend}
    */
    readonly backend: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#cidr_list SshSecretBackendRole#cidr_list}
    */
    readonly cidrList?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#default_critical_options SshSecretBackendRole#default_critical_options}
    */
    readonly defaultCriticalOptions?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#default_extensions SshSecretBackendRole#default_extensions}
    */
    readonly defaultExtensions?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#default_user SshSecretBackendRole#default_user}
    */
    readonly defaultUser?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#key_id_format SshSecretBackendRole#key_id_format}
    */
    readonly keyIdFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#key_type SshSecretBackendRole#key_type}
    */
    readonly keyType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#max_ttl SshSecretBackendRole#max_ttl}
    */
    readonly maxTtl?: string;
    /**
    * Unique name for the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#name SshSecretBackendRole#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#ttl SshSecretBackendRole#ttl}
    */
    readonly ttl?: string;
    /**
    * allowed_user_key_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#allowed_user_key_config SshSecretBackendRole#allowed_user_key_config}
    */
    readonly allowedUserKeyConfig?: SshSecretBackendRoleAllowedUserKeyConfig[] | cdktf.IResolvable;
}
export interface SshSecretBackendRoleAllowedUserKeyConfig {
    /**
    * List of allowed key lengths, vault-1.10 and above
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#lengths SshSecretBackendRole#lengths}
    */
    readonly lengths: number[];
    /**
    * Key type, choices:
  rsa, ecdsa, ec, dsa, ed25519, ssh-rsa, ssh-dss, ssh-ed25519, ecdsa-sha2-nistp256, ecdsa-sha2-nistp384, ecdsa-sha2-nistp521
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role#type SshSecretBackendRole#type}
    */
    readonly type: string;
}
export declare function sshSecretBackendRoleAllowedUserKeyConfigToTerraform(struct?: SshSecretBackendRoleAllowedUserKeyConfig | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role vault_ssh_secret_backend_role}
*/
export declare class SshSecretBackendRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_ssh_secret_backend_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_role vault_ssh_secret_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SshSecretBackendRoleConfig
    */
    constructor(scope: Construct, id: string, config: SshSecretBackendRoleConfig);
    private _algorithmSigner?;
    get algorithmSigner(): string;
    set algorithmSigner(value: string);
    resetAlgorithmSigner(): void;
    get algorithmSignerInput(): string | undefined;
    private _allowBareDomains?;
    get allowBareDomains(): boolean | cdktf.IResolvable;
    set allowBareDomains(value: boolean | cdktf.IResolvable);
    resetAllowBareDomains(): void;
    get allowBareDomainsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHostCertificates?;
    get allowHostCertificates(): boolean | cdktf.IResolvable;
    set allowHostCertificates(value: boolean | cdktf.IResolvable);
    resetAllowHostCertificates(): void;
    get allowHostCertificatesInput(): boolean | cdktf.IResolvable | undefined;
    private _allowSubdomains?;
    get allowSubdomains(): boolean | cdktf.IResolvable;
    set allowSubdomains(value: boolean | cdktf.IResolvable);
    resetAllowSubdomains(): void;
    get allowSubdomainsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowUserCertificates?;
    get allowUserCertificates(): boolean | cdktf.IResolvable;
    set allowUserCertificates(value: boolean | cdktf.IResolvable);
    resetAllowUserCertificates(): void;
    get allowUserCertificatesInput(): boolean | cdktf.IResolvable | undefined;
    private _allowUserKeyIds?;
    get allowUserKeyIds(): boolean | cdktf.IResolvable;
    set allowUserKeyIds(value: boolean | cdktf.IResolvable);
    resetAllowUserKeyIds(): void;
    get allowUserKeyIdsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowedCriticalOptions?;
    get allowedCriticalOptions(): string;
    set allowedCriticalOptions(value: string);
    resetAllowedCriticalOptions(): void;
    get allowedCriticalOptionsInput(): string | undefined;
    private _allowedDomains?;
    get allowedDomains(): string;
    set allowedDomains(value: string);
    resetAllowedDomains(): void;
    get allowedDomainsInput(): string | undefined;
    private _allowedExtensions?;
    get allowedExtensions(): string;
    set allowedExtensions(value: string);
    resetAllowedExtensions(): void;
    get allowedExtensionsInput(): string | undefined;
    private _allowedUserKeyLengths?;
    get allowedUserKeyLengths(): {
        [key: string]: number;
    };
    set allowedUserKeyLengths(value: {
        [key: string]: number;
    });
    resetAllowedUserKeyLengths(): void;
    get allowedUserKeyLengthsInput(): {
        [key: string]: number;
    } | undefined;
    private _allowedUsers?;
    get allowedUsers(): string;
    set allowedUsers(value: string);
    resetAllowedUsers(): void;
    get allowedUsersInput(): string | undefined;
    private _allowedUsersTemplate?;
    get allowedUsersTemplate(): boolean | cdktf.IResolvable;
    set allowedUsersTemplate(value: boolean | cdktf.IResolvable);
    resetAllowedUsersTemplate(): void;
    get allowedUsersTemplateInput(): boolean | cdktf.IResolvable | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _cidrList?;
    get cidrList(): string;
    set cidrList(value: string);
    resetCidrList(): void;
    get cidrListInput(): string | undefined;
    private _defaultCriticalOptions?;
    get defaultCriticalOptions(): {
        [key: string]: string;
    };
    set defaultCriticalOptions(value: {
        [key: string]: string;
    });
    resetDefaultCriticalOptions(): void;
    get defaultCriticalOptionsInput(): {
        [key: string]: string;
    } | undefined;
    private _defaultExtensions?;
    get defaultExtensions(): {
        [key: string]: string;
    };
    set defaultExtensions(value: {
        [key: string]: string;
    });
    resetDefaultExtensions(): void;
    get defaultExtensionsInput(): {
        [key: string]: string;
    } | undefined;
    private _defaultUser?;
    get defaultUser(): string;
    set defaultUser(value: string);
    resetDefaultUser(): void;
    get defaultUserInput(): string | undefined;
    get id(): string;
    private _keyIdFormat?;
    get keyIdFormat(): string;
    set keyIdFormat(value: string);
    resetKeyIdFormat(): void;
    get keyIdFormatInput(): string | undefined;
    private _keyType?;
    get keyType(): string;
    set keyType(value: string);
    get keyTypeInput(): string | undefined;
    private _maxTtl?;
    get maxTtl(): string;
    set maxTtl(value: string);
    resetMaxTtl(): void;
    get maxTtlInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    resetTtl(): void;
    get ttlInput(): string | undefined;
    private _allowedUserKeyConfig?;
    get allowedUserKeyConfig(): SshSecretBackendRoleAllowedUserKeyConfig[] | cdktf.IResolvable;
    set allowedUserKeyConfig(value: SshSecretBackendRoleAllowedUserKeyConfig[] | cdktf.IResolvable);
    resetAllowedUserKeyConfig(): void;
    get allowedUserKeyConfigInput(): cdktf.IResolvable | SshSecretBackendRoleAllowedUserKeyConfig[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=ssh-secret-backend-role.d.ts.map