import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SshSecretBackendCaConfig extends cdktf.TerraformMetaArguments {
    /**
    * The path of the SSH Secret Backend where the CA should be configured
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_ca#backend SshSecretBackendCa#backend}
    */
    readonly backend?: string;
    /**
    * Whether Vault should generate the signing key pair internally.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_ca#generate_signing_key SshSecretBackendCa#generate_signing_key}
    */
    readonly generateSigningKey?: boolean | cdktf.IResolvable;
    /**
    * Private key part the SSH CA key pair; required if generate_signing_key is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_ca#private_key SshSecretBackendCa#private_key}
    */
    readonly privateKey?: string;
    /**
    * Public key part the SSH CA key pair; required if generate_signing_key is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_ca#public_key SshSecretBackendCa#public_key}
    */
    readonly publicKey?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_ca vault_ssh_secret_backend_ca}
*/
export declare class SshSecretBackendCa extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_ssh_secret_backend_ca";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/ssh_secret_backend_ca vault_ssh_secret_backend_ca} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SshSecretBackendCaConfig = {}
    */
    constructor(scope: Construct, id: string, config?: SshSecretBackendCaConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    private _generateSigningKey?;
    get generateSigningKey(): boolean | cdktf.IResolvable;
    set generateSigningKey(value: boolean | cdktf.IResolvable);
    resetGenerateSigningKey(): void;
    get generateSigningKeyInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _privateKey?;
    get privateKey(): string;
    set privateKey(value: string);
    resetPrivateKey(): void;
    get privateKeyInput(): string | undefined;
    private _publicKey?;
    get publicKey(): string;
    set publicKey(value: string);
    resetPublicKey(): void;
    get publicKeyInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=ssh-secret-backend-ca.d.ts.map