import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RgpPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Enforcement level of Sentinel policy. Can be one of: 'advisory', 'soft-mandatory' or 'hard-mandatory'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rgp_policy#enforcement_level RgpPolicy#enforcement_level}
    */
    readonly enforcementLevel: string;
    /**
    * Name of the policy
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rgp_policy#name RgpPolicy#name}
    */
    readonly name: string;
    /**
    * The policy document
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rgp_policy#policy RgpPolicy#policy}
    */
    readonly policy: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/rgp_policy vault_rgp_policy}
*/
export declare class RgpPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_rgp_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/rgp_policy vault_rgp_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RgpPolicyConfig
    */
    constructor(scope: Construct, id: string, config: RgpPolicyConfig);
    private _enforcementLevel?;
    get enforcementLevel(): string;
    set enforcementLevel(value: string);
    get enforcementLevelInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _policy?;
    get policy(): string;
    set policy(value: string);
    get policyInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=rgp-policy.d.ts.map