"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RaftSnapshotAgentConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config vault_raft_snapshot_agent_config}
*/
class RaftSnapshotAgentConfig extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config vault_raft_snapshot_agent_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RaftSnapshotAgentConfigConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_raft_snapshot_agent_config',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.6.0',
                providerVersionConstraint: '~> 3.6.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._awsAccessKeyId = config.awsAccessKeyId;
        this._awsS3Bucket = config.awsS3Bucket;
        this._awsS3DisableTls = config.awsS3DisableTls;
        this._awsS3EnableKms = config.awsS3EnableKms;
        this._awsS3Endpoint = config.awsS3Endpoint;
        this._awsS3ForcePathStyle = config.awsS3ForcePathStyle;
        this._awsS3KmsKey = config.awsS3KmsKey;
        this._awsS3Region = config.awsS3Region;
        this._awsS3ServerSideEncryption = config.awsS3ServerSideEncryption;
        this._awsSecretAccessKey = config.awsSecretAccessKey;
        this._awsSessionToken = config.awsSessionToken;
        this._azureAccountKey = config.azureAccountKey;
        this._azureAccountName = config.azureAccountName;
        this._azureBlobEnvironment = config.azureBlobEnvironment;
        this._azureContainerName = config.azureContainerName;
        this._azureEndpoint = config.azureEndpoint;
        this._filePrefix = config.filePrefix;
        this._googleDisableTls = config.googleDisableTls;
        this._googleEndpoint = config.googleEndpoint;
        this._googleGcsBucket = config.googleGcsBucket;
        this._googleServiceAccountKey = config.googleServiceAccountKey;
        this._intervalSeconds = config.intervalSeconds;
        this._localMaxSpace = config.localMaxSpace;
        this._name = config.name;
        this._pathPrefix = config.pathPrefix;
        this._retain = config.retain;
        this._storageType = config.storageType;
    }
    get awsAccessKeyId() {
        return this.getStringAttribute('aws_access_key_id');
    }
    set awsAccessKeyId(value) {
        this._awsAccessKeyId = value;
    }
    resetAwsAccessKeyId() {
        this._awsAccessKeyId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsAccessKeyIdInput() {
        return this._awsAccessKeyId;
    }
    get awsS3Bucket() {
        return this.getStringAttribute('aws_s3_bucket');
    }
    set awsS3Bucket(value) {
        this._awsS3Bucket = value;
    }
    resetAwsS3Bucket() {
        this._awsS3Bucket = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3BucketInput() {
        return this._awsS3Bucket;
    }
    get awsS3DisableTls() {
        return this.getBooleanAttribute('aws_s3_disable_tls');
    }
    set awsS3DisableTls(value) {
        this._awsS3DisableTls = value;
    }
    resetAwsS3DisableTls() {
        this._awsS3DisableTls = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3DisableTlsInput() {
        return this._awsS3DisableTls;
    }
    get awsS3EnableKms() {
        return this.getBooleanAttribute('aws_s3_enable_kms');
    }
    set awsS3EnableKms(value) {
        this._awsS3EnableKms = value;
    }
    resetAwsS3EnableKms() {
        this._awsS3EnableKms = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3EnableKmsInput() {
        return this._awsS3EnableKms;
    }
    get awsS3Endpoint() {
        return this.getStringAttribute('aws_s3_endpoint');
    }
    set awsS3Endpoint(value) {
        this._awsS3Endpoint = value;
    }
    resetAwsS3Endpoint() {
        this._awsS3Endpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3EndpointInput() {
        return this._awsS3Endpoint;
    }
    get awsS3ForcePathStyle() {
        return this.getBooleanAttribute('aws_s3_force_path_style');
    }
    set awsS3ForcePathStyle(value) {
        this._awsS3ForcePathStyle = value;
    }
    resetAwsS3ForcePathStyle() {
        this._awsS3ForcePathStyle = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3ForcePathStyleInput() {
        return this._awsS3ForcePathStyle;
    }
    get awsS3KmsKey() {
        return this.getStringAttribute('aws_s3_kms_key');
    }
    set awsS3KmsKey(value) {
        this._awsS3KmsKey = value;
    }
    resetAwsS3KmsKey() {
        this._awsS3KmsKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3KmsKeyInput() {
        return this._awsS3KmsKey;
    }
    get awsS3Region() {
        return this.getStringAttribute('aws_s3_region');
    }
    set awsS3Region(value) {
        this._awsS3Region = value;
    }
    resetAwsS3Region() {
        this._awsS3Region = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3RegionInput() {
        return this._awsS3Region;
    }
    get awsS3ServerSideEncryption() {
        return this.getBooleanAttribute('aws_s3_server_side_encryption');
    }
    set awsS3ServerSideEncryption(value) {
        this._awsS3ServerSideEncryption = value;
    }
    resetAwsS3ServerSideEncryption() {
        this._awsS3ServerSideEncryption = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsS3ServerSideEncryptionInput() {
        return this._awsS3ServerSideEncryption;
    }
    get awsSecretAccessKey() {
        return this.getStringAttribute('aws_secret_access_key');
    }
    set awsSecretAccessKey(value) {
        this._awsSecretAccessKey = value;
    }
    resetAwsSecretAccessKey() {
        this._awsSecretAccessKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsSecretAccessKeyInput() {
        return this._awsSecretAccessKey;
    }
    get awsSessionToken() {
        return this.getStringAttribute('aws_session_token');
    }
    set awsSessionToken(value) {
        this._awsSessionToken = value;
    }
    resetAwsSessionToken() {
        this._awsSessionToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsSessionTokenInput() {
        return this._awsSessionToken;
    }
    get azureAccountKey() {
        return this.getStringAttribute('azure_account_key');
    }
    set azureAccountKey(value) {
        this._azureAccountKey = value;
    }
    resetAzureAccountKey() {
        this._azureAccountKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureAccountKeyInput() {
        return this._azureAccountKey;
    }
    get azureAccountName() {
        return this.getStringAttribute('azure_account_name');
    }
    set azureAccountName(value) {
        this._azureAccountName = value;
    }
    resetAzureAccountName() {
        this._azureAccountName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureAccountNameInput() {
        return this._azureAccountName;
    }
    get azureBlobEnvironment() {
        return this.getStringAttribute('azure_blob_environment');
    }
    set azureBlobEnvironment(value) {
        this._azureBlobEnvironment = value;
    }
    resetAzureBlobEnvironment() {
        this._azureBlobEnvironment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureBlobEnvironmentInput() {
        return this._azureBlobEnvironment;
    }
    get azureContainerName() {
        return this.getStringAttribute('azure_container_name');
    }
    set azureContainerName(value) {
        this._azureContainerName = value;
    }
    resetAzureContainerName() {
        this._azureContainerName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureContainerNameInput() {
        return this._azureContainerName;
    }
    get azureEndpoint() {
        return this.getStringAttribute('azure_endpoint');
    }
    set azureEndpoint(value) {
        this._azureEndpoint = value;
    }
    resetAzureEndpoint() {
        this._azureEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureEndpointInput() {
        return this._azureEndpoint;
    }
    get filePrefix() {
        return this.getStringAttribute('file_prefix');
    }
    set filePrefix(value) {
        this._filePrefix = value;
    }
    resetFilePrefix() {
        this._filePrefix = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get filePrefixInput() {
        return this._filePrefix;
    }
    get googleDisableTls() {
        return this.getBooleanAttribute('google_disable_tls');
    }
    set googleDisableTls(value) {
        this._googleDisableTls = value;
    }
    resetGoogleDisableTls() {
        this._googleDisableTls = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get googleDisableTlsInput() {
        return this._googleDisableTls;
    }
    get googleEndpoint() {
        return this.getStringAttribute('google_endpoint');
    }
    set googleEndpoint(value) {
        this._googleEndpoint = value;
    }
    resetGoogleEndpoint() {
        this._googleEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get googleEndpointInput() {
        return this._googleEndpoint;
    }
    get googleGcsBucket() {
        return this.getStringAttribute('google_gcs_bucket');
    }
    set googleGcsBucket(value) {
        this._googleGcsBucket = value;
    }
    resetGoogleGcsBucket() {
        this._googleGcsBucket = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get googleGcsBucketInput() {
        return this._googleGcsBucket;
    }
    get googleServiceAccountKey() {
        return this.getStringAttribute('google_service_account_key');
    }
    set googleServiceAccountKey(value) {
        this._googleServiceAccountKey = value;
    }
    resetGoogleServiceAccountKey() {
        this._googleServiceAccountKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get googleServiceAccountKeyInput() {
        return this._googleServiceAccountKey;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get intervalSeconds() {
        return this.getNumberAttribute('interval_seconds');
    }
    set intervalSeconds(value) {
        this._intervalSeconds = value;
    }
    // Temporarily expose input value. Use with caution.
    get intervalSecondsInput() {
        return this._intervalSeconds;
    }
    get localMaxSpace() {
        return this.getNumberAttribute('local_max_space');
    }
    set localMaxSpace(value) {
        this._localMaxSpace = value;
    }
    resetLocalMaxSpace() {
        this._localMaxSpace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get localMaxSpaceInput() {
        return this._localMaxSpace;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get pathPrefix() {
        return this.getStringAttribute('path_prefix');
    }
    set pathPrefix(value) {
        this._pathPrefix = value;
    }
    // Temporarily expose input value. Use with caution.
    get pathPrefixInput() {
        return this._pathPrefix;
    }
    get retain() {
        return this.getNumberAttribute('retain');
    }
    set retain(value) {
        this._retain = value;
    }
    resetRetain() {
        this._retain = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get retainInput() {
        return this._retain;
    }
    get storageType() {
        return this.getStringAttribute('storage_type');
    }
    set storageType(value) {
        this._storageType = value;
    }
    // Temporarily expose input value. Use with caution.
    get storageTypeInput() {
        return this._storageType;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            aws_access_key_id: cdktf.stringToTerraform(this._awsAccessKeyId),
            aws_s3_bucket: cdktf.stringToTerraform(this._awsS3Bucket),
            aws_s3_disable_tls: cdktf.booleanToTerraform(this._awsS3DisableTls),
            aws_s3_enable_kms: cdktf.booleanToTerraform(this._awsS3EnableKms),
            aws_s3_endpoint: cdktf.stringToTerraform(this._awsS3Endpoint),
            aws_s3_force_path_style: cdktf.booleanToTerraform(this._awsS3ForcePathStyle),
            aws_s3_kms_key: cdktf.stringToTerraform(this._awsS3KmsKey),
            aws_s3_region: cdktf.stringToTerraform(this._awsS3Region),
            aws_s3_server_side_encryption: cdktf.booleanToTerraform(this._awsS3ServerSideEncryption),
            aws_secret_access_key: cdktf.stringToTerraform(this._awsSecretAccessKey),
            aws_session_token: cdktf.stringToTerraform(this._awsSessionToken),
            azure_account_key: cdktf.stringToTerraform(this._azureAccountKey),
            azure_account_name: cdktf.stringToTerraform(this._azureAccountName),
            azure_blob_environment: cdktf.stringToTerraform(this._azureBlobEnvironment),
            azure_container_name: cdktf.stringToTerraform(this._azureContainerName),
            azure_endpoint: cdktf.stringToTerraform(this._azureEndpoint),
            file_prefix: cdktf.stringToTerraform(this._filePrefix),
            google_disable_tls: cdktf.booleanToTerraform(this._googleDisableTls),
            google_endpoint: cdktf.stringToTerraform(this._googleEndpoint),
            google_gcs_bucket: cdktf.stringToTerraform(this._googleGcsBucket),
            google_service_account_key: cdktf.stringToTerraform(this._googleServiceAccountKey),
            interval_seconds: cdktf.numberToTerraform(this._intervalSeconds),
            local_max_space: cdktf.numberToTerraform(this._localMaxSpace),
            name: cdktf.stringToTerraform(this._name),
            path_prefix: cdktf.stringToTerraform(this._pathPrefix),
            retain: cdktf.numberToTerraform(this._retain),
            storage_type: cdktf.stringToTerraform(this._storageType),
        };
    }
}
exports.RaftSnapshotAgentConfig = RaftSnapshotAgentConfig;
_a = JSII_RTTI_SYMBOL_1;
RaftSnapshotAgentConfig[_a] = { fqn: "hashicorp_vault.RaftSnapshotAgentConfig", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
RaftSnapshotAgentConfig.tfResourceType = "vault_raft_snapshot_agent_config";
//# sourceMappingURL=data:application/json;base64,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