"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RaftAutopilot = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/raft_autopilot vault_raft_autopilot}
*/
class RaftAutopilot extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/raft_autopilot vault_raft_autopilot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RaftAutopilotConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'vault_raft_autopilot',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.6.0',
                providerVersionConstraint: '~> 3.6.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._cleanupDeadServers = config.cleanupDeadServers;
        this._deadServerLastContactThreshold = config.deadServerLastContactThreshold;
        this._lastContactThreshold = config.lastContactThreshold;
        this._maxTrailingLogs = config.maxTrailingLogs;
        this._minQuorum = config.minQuorum;
        this._serverStabilizationTime = config.serverStabilizationTime;
    }
    get cleanupDeadServers() {
        return this.getBooleanAttribute('cleanup_dead_servers');
    }
    set cleanupDeadServers(value) {
        this._cleanupDeadServers = value;
    }
    resetCleanupDeadServers() {
        this._cleanupDeadServers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cleanupDeadServersInput() {
        return this._cleanupDeadServers;
    }
    get deadServerLastContactThreshold() {
        return this.getStringAttribute('dead_server_last_contact_threshold');
    }
    set deadServerLastContactThreshold(value) {
        this._deadServerLastContactThreshold = value;
    }
    resetDeadServerLastContactThreshold() {
        this._deadServerLastContactThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deadServerLastContactThresholdInput() {
        return this._deadServerLastContactThreshold;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get lastContactThreshold() {
        return this.getStringAttribute('last_contact_threshold');
    }
    set lastContactThreshold(value) {
        this._lastContactThreshold = value;
    }
    resetLastContactThreshold() {
        this._lastContactThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lastContactThresholdInput() {
        return this._lastContactThreshold;
    }
    get maxTrailingLogs() {
        return this.getNumberAttribute('max_trailing_logs');
    }
    set maxTrailingLogs(value) {
        this._maxTrailingLogs = value;
    }
    resetMaxTrailingLogs() {
        this._maxTrailingLogs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxTrailingLogsInput() {
        return this._maxTrailingLogs;
    }
    get minQuorum() {
        return this.getNumberAttribute('min_quorum');
    }
    set minQuorum(value) {
        this._minQuorum = value;
    }
    resetMinQuorum() {
        this._minQuorum = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minQuorumInput() {
        return this._minQuorum;
    }
    get serverStabilizationTime() {
        return this.getStringAttribute('server_stabilization_time');
    }
    set serverStabilizationTime(value) {
        this._serverStabilizationTime = value;
    }
    resetServerStabilizationTime() {
        this._serverStabilizationTime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serverStabilizationTimeInput() {
        return this._serverStabilizationTime;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            cleanup_dead_servers: cdktf.booleanToTerraform(this._cleanupDeadServers),
            dead_server_last_contact_threshold: cdktf.stringToTerraform(this._deadServerLastContactThreshold),
            last_contact_threshold: cdktf.stringToTerraform(this._lastContactThreshold),
            max_trailing_logs: cdktf.numberToTerraform(this._maxTrailingLogs),
            min_quorum: cdktf.numberToTerraform(this._minQuorum),
            server_stabilization_time: cdktf.stringToTerraform(this._serverStabilizationTime),
        };
    }
}
exports.RaftAutopilot = RaftAutopilot;
_a = JSII_RTTI_SYMBOL_1;
RaftAutopilot[_a] = { fqn: "hashicorp_vault.RaftAutopilot", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
RaftAutopilot.tfResourceType = "vault_raft_autopilot";
//# sourceMappingURL=data:application/json;base64,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