import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RaftAutopilotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies whether to remove dead server nodes periodically or when a new server joins. This requires that min-quorum is also set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_autopilot#cleanup_dead_servers RaftAutopilot#cleanup_dead_servers}
    */
    readonly cleanupDeadServers?: boolean | cdktf.IResolvable;
    /**
    * Limit the amount of time a server can go without leader contact before being considered failed. This only takes effect when cleanup_dead_servers is set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_autopilot#dead_server_last_contact_threshold RaftAutopilot#dead_server_last_contact_threshold}
    */
    readonly deadServerLastContactThreshold?: string;
    /**
    * Limit the amount of time a server can go without leader contact before being considered unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_autopilot#last_contact_threshold RaftAutopilot#last_contact_threshold}
    */
    readonly lastContactThreshold?: string;
    /**
    * Maximum number of log entries in the Raft log that a server can be behind its leader before being considered unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_autopilot#max_trailing_logs RaftAutopilot#max_trailing_logs}
    */
    readonly maxTrailingLogs?: number;
    /**
    * Minimum number of servers allowed in a cluster before autopilot can prune dead servers. This should at least be 3. Applicable only for voting nodes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_autopilot#min_quorum RaftAutopilot#min_quorum}
    */
    readonly minQuorum?: number;
    /**
    * Minimum amount of time a server must be stable in the 'healthy' state before being added to the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_autopilot#server_stabilization_time RaftAutopilot#server_stabilization_time}
    */
    readonly serverStabilizationTime?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/raft_autopilot vault_raft_autopilot}
*/
export declare class RaftAutopilot extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_raft_autopilot";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/raft_autopilot vault_raft_autopilot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RaftAutopilotConfig = {}
    */
    constructor(scope: Construct, id: string, config?: RaftAutopilotConfig);
    private _cleanupDeadServers?;
    get cleanupDeadServers(): boolean | cdktf.IResolvable;
    set cleanupDeadServers(value: boolean | cdktf.IResolvable);
    resetCleanupDeadServers(): void;
    get cleanupDeadServersInput(): boolean | cdktf.IResolvable | undefined;
    private _deadServerLastContactThreshold?;
    get deadServerLastContactThreshold(): string;
    set deadServerLastContactThreshold(value: string);
    resetDeadServerLastContactThreshold(): void;
    get deadServerLastContactThresholdInput(): string | undefined;
    get id(): string;
    private _lastContactThreshold?;
    get lastContactThreshold(): string;
    set lastContactThreshold(value: string);
    resetLastContactThreshold(): void;
    get lastContactThresholdInput(): string | undefined;
    private _maxTrailingLogs?;
    get maxTrailingLogs(): number;
    set maxTrailingLogs(value: number);
    resetMaxTrailingLogs(): void;
    get maxTrailingLogsInput(): number | undefined;
    private _minQuorum?;
    get minQuorum(): number;
    set minQuorum(value: number);
    resetMinQuorum(): void;
    get minQuorumInput(): number | undefined;
    private _serverStabilizationTime?;
    get serverStabilizationTime(): string;
    set serverStabilizationTime(value: string);
    resetServerStabilizationTime(): void;
    get serverStabilizationTimeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=raft-autopilot.d.ts.map