import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RabbitmqSecretBackendRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The path of the Rabbitmq Secret Backend the role belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#backend RabbitmqSecretBackendRole#backend}
    */
    readonly backend: string;
    /**
    * Unique name for the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#name RabbitmqSecretBackendRole#name}
    */
    readonly name: string;
    /**
    * Specifies a comma-separated RabbitMQ management tags.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#tags RabbitmqSecretBackendRole#tags}
    */
    readonly tags?: string;
    /**
    * vhost block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#vhost RabbitmqSecretBackendRole#vhost}
    */
    readonly vhost?: RabbitmqSecretBackendRoleVhost[] | cdktf.IResolvable;
    /**
    * vhost_topic block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#vhost_topic RabbitmqSecretBackendRole#vhost_topic}
    */
    readonly vhostTopic?: RabbitmqSecretBackendRoleVhostTopic[] | cdktf.IResolvable;
}
export interface RabbitmqSecretBackendRoleVhost {
    /**
    * The configure permissions for this vhost.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#configure RabbitmqSecretBackendRole#configure}
    */
    readonly configure: string;
    /**
    * The vhost to set permissions for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#host RabbitmqSecretBackendRole#host}
    */
    readonly host: string;
    /**
    * The read permissions for this vhost.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#read RabbitmqSecretBackendRole#read}
    */
    readonly read: string;
    /**
    * The write permissions for this vhost.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#write RabbitmqSecretBackendRole#write}
    */
    readonly write: string;
}
export declare function rabbitmqSecretBackendRoleVhostToTerraform(struct?: RabbitmqSecretBackendRoleVhost | cdktf.IResolvable): any;
export interface RabbitmqSecretBackendRoleVhostTopicVhost {
    /**
    * The read permissions for this vhost.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#read RabbitmqSecretBackendRole#read}
    */
    readonly read: string;
    /**
    * The vhost to set permissions for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#topic RabbitmqSecretBackendRole#topic}
    */
    readonly topic: string;
    /**
    * The write permissions for this vhost.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#write RabbitmqSecretBackendRole#write}
    */
    readonly write: string;
}
export declare function rabbitmqSecretBackendRoleVhostTopicVhostToTerraform(struct?: RabbitmqSecretBackendRoleVhostTopicVhost | cdktf.IResolvable): any;
export interface RabbitmqSecretBackendRoleVhostTopic {
    /**
    * The vhost to set permissions for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#host RabbitmqSecretBackendRole#host}
    */
    readonly host: string;
    /**
    * vhost block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#vhost RabbitmqSecretBackendRole#vhost}
    */
    readonly vhost?: RabbitmqSecretBackendRoleVhostTopicVhost[] | cdktf.IResolvable;
}
export declare function rabbitmqSecretBackendRoleVhostTopicToTerraform(struct?: RabbitmqSecretBackendRoleVhostTopic | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role vault_rabbitmq_secret_backend_role}
*/
export declare class RabbitmqSecretBackendRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_rabbitmq_secret_backend_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role vault_rabbitmq_secret_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RabbitmqSecretBackendRoleConfig
    */
    constructor(scope: Construct, id: string, config: RabbitmqSecretBackendRoleConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): string;
    set tags(value: string);
    resetTags(): void;
    get tagsInput(): string | undefined;
    private _vhost?;
    get vhost(): RabbitmqSecretBackendRoleVhost[] | cdktf.IResolvable;
    set vhost(value: RabbitmqSecretBackendRoleVhost[] | cdktf.IResolvable);
    resetVhost(): void;
    get vhostInput(): cdktf.IResolvable | RabbitmqSecretBackendRoleVhost[] | undefined;
    private _vhostTopic?;
    get vhostTopic(): RabbitmqSecretBackendRoleVhostTopic[] | cdktf.IResolvable;
    set vhostTopic(value: RabbitmqSecretBackendRoleVhostTopic[] | cdktf.IResolvable);
    resetVhostTopic(): void;
    get vhostTopicInput(): cdktf.IResolvable | RabbitmqSecretBackendRoleVhostTopic[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=rabbitmq-secret-backend-role.d.ts.map