import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface QuotaRateLimitConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the quota.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/quota_rate_limit#name QuotaRateLimit#name}
    */
    readonly name: string;
    /**
    * Path of the mount or namespace to apply the quota. A blank path configures a global rate limit quota.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/quota_rate_limit#path QuotaRateLimit#path}
    */
    readonly path?: string;
    /**
    * The maximum number of requests at any given second to be allowed by the quota rule. The rate must be positive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/quota_rate_limit#rate QuotaRateLimit#rate}
    */
    readonly rate: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/quota_rate_limit vault_quota_rate_limit}
*/
export declare class QuotaRateLimit extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_quota_rate_limit";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/quota_rate_limit vault_quota_rate_limit} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options QuotaRateLimitConfig
    */
    constructor(scope: Construct, id: string, config: QuotaRateLimitConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _rate?;
    get rate(): number;
    set rate(value: number);
    get rateInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=quota-rate-limit.d.ts.map