import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface QuotaLeaseCountConfig extends cdktf.TerraformMetaArguments {
    /**
    * The maximum number of leases to be allowed by the quota rule. The max_leases must be positive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/quota_lease_count#max_leases QuotaLeaseCount#max_leases}
    */
    readonly maxLeases: number;
    /**
    * The name of the quota.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/quota_lease_count#name QuotaLeaseCount#name}
    */
    readonly name: string;
    /**
    * Path of the mount or namespace to apply the quota. A blank path configures a global lease count quota.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/quota_lease_count#path QuotaLeaseCount#path}
    */
    readonly path?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/quota_lease_count vault_quota_lease_count}
*/
export declare class QuotaLeaseCount extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_quota_lease_count";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/quota_lease_count vault_quota_lease_count} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options QuotaLeaseCountConfig
    */
    constructor(scope: Construct, id: string, config: QuotaLeaseCountConfig);
    get id(): string;
    private _maxLeases?;
    get maxLeases(): number;
    set maxLeases(value: number);
    get maxLeasesInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=quota-lease-count.d.ts.map