import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name of the policy
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/policy#name Policy#name}
    */
    readonly name: string;
    /**
    * The policy document
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/policy#policy Policy#policy}
    */
    readonly policy: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/policy vault_policy}
*/
export declare class Policy extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/policy vault_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PolicyConfig
    */
    constructor(scope: Construct, id: string, config: PolicyConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _policy?;
    get policy(): string;
    set policy(value: string);
    get policyInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=policy.d.ts.map